/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionHelper;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.VerySimpleRdfsBackwardsChainingConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.LazyValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private List<NodeShape> nodeShapes;
    private final SailConnection previousStateConnection;
    private final SailConnection serializableConnection;
    private final SailConnection previousStateSerializableConnection;
    Sail addedStatements;
    Sail removedStatements;
    private final HashSet<Statement> addedStatementsSet = new HashSet();
    private final HashSet<Statement> removedStatementsSet = new HashSet();
    private boolean isShapeRefreshNeeded = false;
    private boolean shapesModifiedInCurrentTransaction = false;
    public final ShaclSail sail;
    private Stats stats;
    RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private boolean preparedHasRun = false;
    private final SailRepositoryConnection shapesRepoConnection;
    private Lock writeLock;
    private boolean connectionListenerActive = false;
    private IsolationLevel currentIsolationLevel = null;
    private Settings transactionSettings;
    private TransactionSetting[] transactionSettingsRaw = new TransactionSetting[0];

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailConnection previousStateConnection, SailConnection serializableConnection, SailConnection previousStateSerializableConnection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.serializableConnection = serializableConnection;
        this.previousStateSerializableConnection = previousStateSerializableConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
    }

    private Settings getDefaultSettings(ShaclSail sail) {
        return new Settings(sail.isCacheSelectNodes(), sail.isValidationEnabled());
    }

    @Override
    public void setTransactionSettings(TransactionSetting ... settings) {
        super.setTransactionSettings(settings);
        this.transactionSettingsRaw = settings;
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel level) throws SailException {
        this.currentIsolationLevel = level;
        this.transactionSettings = this.getDefaultSettings(this.sail);
        Arrays.stream(this.transactionSettingsRaw).filter(Objects::nonNull).forEach(setting -> {
            if (setting instanceof ShaclSail.TransactionSettings.ValidationApproach) {
                this.transactionSettings.validationApproach = (ShaclSail.TransactionSettings.ValidationApproach)setting;
            }
        });
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.hasStatement(null, null, null, false, new Resource[0]);
            this.shapesRepoConnection.begin(this.currentIsolationLevel);
            this.previousStateConnection.begin(this.currentIsolationLevel);
            this.previousStateConnection.hasStatement(null, null, null, false, new Resource[0]);
        }
        this.stats.setBaseSailEmpty(this.isEmpty());
        if (this.transactionSettings.getValidationApproach() == ShaclSail.TransactionSettings.ValidationApproach.Disabled || this.transactionSettings.getValidationApproach() == ShaclSail.TransactionSettings.ValidationApproach.Bulk) {
            this.removeConnectionListener(this);
        } else if (this.stats.isBaseSailEmpty()) {
            this.removeConnectionListener(this);
        } else {
            this.addConnectionListener(this);
        }
    }

    @Override
    public void addConnectionListener(SailConnectionListener listener) {
        if (!this.connectionListenerActive && this.isValidationEnabled()) {
            super.addConnectionListener(this);
            this.connectionListenerActive = true;
        }
    }

    boolean isValidationEnabled() {
        return this.transactionSettings.getValidationApproach() != ShaclSail.TransactionSettings.ValidationApproach.Disabled;
    }

    @Override
    public void removeConnectionListener(SailConnectionListener listener) {
        super.removeConnectionListener(listener);
        this.connectionListenerActive = false;
    }

    private Sail getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel(IsolationLevels.NONE);
        sail.init();
        return sail;
    }

    @Override
    public void commit() throws SailException {
        if (!this.preparedHasRun) {
            this.prepare();
        }
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        this.previousStateConnection.commit();
        super.commit();
        this.shapesRepoConnection.commit();
        if (this.shapesModifiedInCurrentTransaction) {
            this.sail.setNodeShapes(this.nodeShapes);
        }
        if (this.writeLock != null && this.writeLock.isActive()) {
            this.writeLock = this.sail.releaseExclusiveWriteLock(this.writeLock);
        }
        assert (this.writeLock == null);
        if (this.sail.isPerformanceLogging()) {
            logger.info("commit() excluding validation and cleanup took {} ms", (Object)(System.currentTimeMillis() - before));
        }
        this.cleanup();
    }

    @Override
    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLock = this.sail.acquireExclusiveWriteLock(this.writeLock);
            this.shapesRepoConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    @Override
    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLock = this.sail.acquireExclusiveWriteLock(this.writeLock);
            this.shapesRepoConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    @Override
    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLock = this.sail.acquireExclusiveWriteLock(this.writeLock);
            this.shapesRepoConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    @Override
    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.writeLock = this.sail.acquireExclusiveWriteLock(this.writeLock);
            this.shapesRepoConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws SailException {
        if (Arrays.asList(contexts).contains(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesRepoConnection.clear(new Resource[0]);
            this.isShapeRefreshNeeded = true;
        }
        super.clear(contexts);
    }

    @Override
    public void rollback() throws SailException {
        this.previousStateConnection.rollback();
        this.shapesRepoConnection.rollback();
        super.rollback();
        if (this.shapesModifiedInCurrentTransaction || this.isShapeRefreshNeeded) {
            this.isShapeRefreshNeeded = true;
            this.refreshShapes();
            if (this.shapesModifiedInCurrentTransaction) {
                this.sail.setNodeShapes(this.nodeShapes);
            }
        }
        if (this.writeLock != null && this.writeLock.isActive()) {
            this.writeLock = this.sail.releaseExclusiveWriteLock(this.writeLock);
        }
        assert (this.writeLock == null);
        this.cleanup();
    }

    private void cleanup() {
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        logger.debug("Cleanup");
        if (this.addedStatements != null) {
            if (this.addedStatements != this.sail.getBaseSail()) {
                this.addedStatements.shutDown();
            }
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatementsSet.clear();
        this.removedStatementsSet.clear();
        this.stats = null;
        this.preparedHasRun = false;
        this.isShapeRefreshNeeded = false;
        this.shapesModifiedInCurrentTransaction = false;
        assert (this.writeLock == null);
        this.currentIsolationLevel = null;
        if (this.sail.isPerformanceLogging()) {
            logger.info("cleanup() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private void refreshShapes() {
        if (this.isShapeRefreshNeeded) {
            this.nodeShapes = this.sail.refreshShapes(this.shapesRepoConnection);
            this.isShapeRefreshNeeded = false;
            this.shapesModifiedInCurrentTransaction = true;
        }
    }

    /*
     * Loose catch block
     */
    private ValidationReport validate(List<NodeShape> nodeShapes, boolean validateEntireBaseSail) {
        try {
            if (!this.isValidationEnabled()) {
                ValidationReport validationReport = new ValidationReport(true);
                return validationReport;
            }
            try (ConnectionsGroup connectionsGroup = this.getConnectionsGroup();){
                ValidationReport validationReport = this.performValidation(nodeShapes, validateEntireBaseSail, connectionsGroup);
                return validationReport;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.rdfsSubClassOfReasoner = null;
        }
    }

    private void prepareValidation() {
        if (!this.isValidationEnabled()) {
            return;
        }
        if (this.sail.isRdfsSubClassReasoning()) {
            this.rdfsSubClassOfReasoner = RdfsSubClassOfReasoner.createReasoner(this);
        }
        this.fillAddedAndRemovedStatementRepositories();
    }

    ConnectionsGroup getConnectionsGroup() {
        return new ConnectionsGroup(new VerySimpleRdfsBackwardsChainingConnection(this, this.rdfsSubClassOfReasoner), this.previousStateConnection, this.addedStatements, this.removedStatements, this.stats, this::getRdfsSubClassOfReasoner, this.transactionSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationReport performValidation(List<NodeShape> nodeShapes, boolean validateEntireBaseSail, ConnectionsGroup connectionsGroup) {
        long beforeValidation = 0L;
        if (this.sail.isPerformanceLogging()) {
            beforeValidation = System.currentTimeMillis();
        }
        try {
            Stream<Callable> callableStream = nodeShapes.stream().flatMap(nodeShape -> nodeShape.generatePlans(connectionsGroup, (NodeShape)nodeShape, this.sail.isLogValidationPlans(), validateEntireBaseSail)).filter(Objects::nonNull).map(planNode -> () -> {
                ValidationExecutionLogger validationExecutionLogger = new ValidationExecutionLogger();
                planNode.receiveLogger(validationExecutionLogger);
                try (CloseableIteration<Tuple, SailException> iterator = planNode.iterator();){
                    if (GlobalValidationExecutionLogging.loggingEnabled) {
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("Start execution of plan " + propertyShape.getNodeShape().toString() + " : " + propertyShape.toString());
                    }
                    long before = 0L;
                    if (this.sail.isPerformanceLogging()) {
                        before = System.currentTimeMillis();
                    }
                    ValidationResultIterator validationResults = new ValidationResultIterator(iterator, this.sail.getEffectiveValidationResultsLimitPerConstraint());
                    validationExecutionLogger.flush();
                    if (this.sail.isPerformanceLogging()) {
                        long after = System.currentTimeMillis();
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("Execution of plan took {} ms for {} : {}", new Object[]{after - before, propertyShape.getNodeShape().toString(), propertyShape.toString()});
                    }
                    if (GlobalValidationExecutionLogging.loggingEnabled) {
                        PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                        logger.info("Finished execution of plan {} : {}", (Object)propertyShape.getNodeShape().toString(), (Object)propertyShape.toString());
                    }
                    if (this.sail.isLogValidationViolations()) {
                        List<Tuple> tuples = validationResults.getTuples();
                        if (!validationResults.conforms()) {
                            PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                            logger.info("SHACL not valid. The following experimental debug results were produced: \n\tNodeShape: {}\n\tPropertyShape: {} \n\t\t{}", new Object[]{propertyShape.getNodeShape().getId(), propertyShape.getId(), tuples.stream().map(a -> a.toString() + " -cause-> " + a.getCause()).collect(Collectors.joining("\n\t\t"))});
                        }
                    }
                    ValidationResultIterator validationResultIterator = validationResults;
                    return validationResultIterator;
                }
            });
            List<ValidationResultIterator> validationResultIterators = this.isParallelValidation() ? callableStream.map(this.sail::submitRunnableToExecutorService).collect(Collectors.toList()).stream().map(f -> {
                try {
                    return (ValidationResultIterator)f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()) : callableStream.map(c -> {
                try {
                    return (ValidationResultIterator)c.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            LazyValidationReport lazyValidationReport = new LazyValidationReport(validationResultIterators, this.sail.getValidationResultsLimitTotal());
            return lazyValidationReport;
        }
        finally {
            if (this.sail.isPerformanceLogging()) {
                logger.info("Actual validation and generating plans took {} ms", (Object)(System.currentTimeMillis() - beforeValidation));
            }
        }
    }

    private boolean isParallelValidation() {
        return this.sail.isParallelValidation() && !this.isBulkValidation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fillAddedAndRemovedStatementRepositories() {
        long before;
        block28: {
            block29: {
                before = 0L;
                if (this.sail.isPerformanceLogging()) {
                    before = System.currentTimeMillis();
                }
                if (!this.stats.isBaseSailEmpty()) break block29;
                this.flush();
                if ((this.rdfsSubClassOfReasoner == null || this.rdfsSubClassOfReasoner.isEmpty()) && this.sail.getBaseSail() instanceof MemoryStore && this.getIsolationLevel() == IsolationLevels.NONE) {
                    this.addedStatements = this.sail.getBaseSail();
                    this.removedStatements = this.getNewMemorySail();
                    break block28;
                } else {
                    this.addedStatements = this.getNewMemorySail();
                    this.removedStatements = this.getNewMemorySail();
                    try (Stream stream = this.getStatements(null, null, null, false, new Resource[0]).stream();
                         SailConnection connection = this.addedStatements.getConnection();){
                        connection.begin(IsolationLevels.NONE);
                        stream.flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
                        connection.commit();
                        break block28;
                    }
                }
            }
            ((Stream)Stream.of(this.addedStatementsSet, this.removedStatementsSet).parallel()).forEach(set -> {
                Sail repository;
                HashSet<Statement> otherSet;
                if (set == this.addedStatementsSet) {
                    otherSet = this.removedStatementsSet;
                    if (this.addedStatements != null && this.addedStatements != this.sail.getBaseSail()) {
                        this.addedStatements.shutDown();
                    }
                    repository = this.addedStatements = this.getNewMemorySail();
                    set.forEach(this.stats::added);
                } else {
                    otherSet = this.addedStatementsSet;
                    if (this.removedStatements != null) {
                        this.removedStatements.shutDown();
                        this.removedStatements = null;
                    }
                    repository = this.removedStatements = this.getNewMemorySail();
                    set.forEach(this.stats::removed);
                }
                try (SailConnection connection = repository.getConnection();){
                    connection.begin(IsolationLevels.NONE);
                    set.stream().filter(statement -> !otherSet.contains(statement)).flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
                    connection.commit();
                }
            });
        }
        if (this.sail.isPerformanceLogging()) {
            logger.info("fillAddedAndRemovedStatementRepositories() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private IsolationLevel getIsolationLevel() {
        return this.currentIsolationLevel;
    }

    @Override
    public synchronized void close() throws SailException {
        try {
            if (this.isActive()) {
                this.rollback();
            }
            this.shapesRepoConnection.close();
            this.previousStateConnection.close();
            this.serializableConnection.close();
            this.previousStateSerializableConnection.close();
            super.close();
        }
        finally {
            this.sail.closeConnection(this);
        }
        assert (this.writeLock == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void prepare() throws SailException {
        block23: {
            void var6_7;
            List<NodeShape> list;
            List<NodeShape> nodeShapesBeforeRefresh;
            boolean useSerializableValidation;
            long before;
            Lock readLock;
            block21: {
                block22: {
                    this.flush();
                    readLock = null;
                    try {
                        before = 0L;
                        if (this.sail.isPerformanceLogging()) {
                            before = System.currentTimeMillis();
                        }
                        boolean bl = useSerializableValidation = this.sail.isSerializableValidation() && this.currentIsolationLevel == IsolationLevels.SNAPSHOT && !this.isBulkValidation() && this.isValidationEnabled();
                        if (useSerializableValidation) {
                            if (this.writeLock == null || !this.writeLock.isActive()) {
                                this.writeLock = this.sail.acquireExclusiveWriteLock(this.writeLock);
                            }
                        } else if (this.writeLock == null || !this.writeLock.isActive()) {
                            readLock = this.sail.acquireReadLock();
                        }
                        this.loadCachedNodeShapes();
                        nodeShapesBeforeRefresh = this.nodeShapes;
                        this.refreshShapes();
                        list = this.nodeShapes;
                        this.stats.setEmpty(this.isEmpty());
                        if (!this.connectionListenerActive || !this.addedStatementsSet.isEmpty() || !this.removedStatementsSet.isEmpty() || this.shapesModifiedInCurrentTransaction || this.stats.isBaseSailEmpty() && !this.stats.isEmpty()) break block21;
                        logger.debug("Nothing has changed, nothing to validate.");
                        if (readLock != null) {
                            readLock = this.sail.releaseReadLock(readLock);
                        }
                        if ($assertionsDisabled || readLock == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (readLock != null) {
                            readLock = this.sail.releaseReadLock(readLock);
                        }
                        assert (readLock == null);
                        this.preparedHasRun = true;
                        this.previousStateConnection.prepare();
                        super.prepare();
                        throw throwable;
                    }
                    throw new AssertionError();
                }
                this.preparedHasRun = true;
                this.previousStateConnection.prepare();
                super.prepare();
                return;
            }
            if (this.shapesModifiedInCurrentTransaction && this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty() && !this.isBulkValidation()) {
                assert (nodeShapesBeforeRefresh != list);
                HashSet<NodeShape> nodeShapesBeforeRefreshSet = new HashSet<NodeShape>(nodeShapesBeforeRefresh);
                List list2 = list.stream().filter(nodeShape -> !nodeShapesBeforeRefreshSet.contains(nodeShape)).collect(Collectors.toList());
            }
            this.prepareValidation();
            ValidationReport invalidTuples = null;
            if (useSerializableValidation) {
                ShaclSail shaclSail = this.sail;
                synchronized (shaclSail) {
                    if (!this.sail.usesSingleConnection()) {
                        invalidTuples = this.serializableValidation((List<NodeShape>)var6_7);
                    }
                }
            }
            if (invalidTuples == null) {
                invalidTuples = this.validate((List<NodeShape>)var6_7, this.shapesModifiedInCurrentTransaction || this.isBulkValidation());
            }
            boolean valid = invalidTuples.conforms();
            if (this.sail.isPerformanceLogging()) {
                logger.info("prepare() including validation excluding locking and super.prepare() took {} ms", (Object)(System.currentTimeMillis() - before));
            }
            if (!valid) {
                throw new ShaclSailValidationException(invalidTuples);
            }
            if (readLock != null) {
                readLock = this.sail.releaseReadLock(readLock);
            }
            if ($assertionsDisabled || readLock == null) break block23;
            throw new AssertionError();
        }
        this.preparedHasRun = true;
        this.previousStateConnection.prepare();
        super.prepare();
    }

    private boolean isBulkValidation() {
        return this.transactionSettings.getValidationApproach() == ShaclSail.TransactionSettings.ValidationApproach.Bulk;
    }

    /*
     * Exception decompiling
     */
    private ValidationReport serializableValidation(List<NodeShape> nodeShapesAfterRefresh) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadCachedNodeShapes() {
        this.nodeShapes = this.sail.getNodeShapes();
    }

    @Override
    public void statementAdded(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.addedStatementsSet.add(statement);
        if (!add) {
            this.removedStatementsSet.remove(statement);
        }
    }

    @Override
    public void statementRemoved(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.removedStatementsSet.add(statement);
        if (!add) {
            this.addedStatementsSet.remove(statement);
        }
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasoner;
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            return ConnectionHelper.getCloseableIteration(this.shapesRepoConnection.getStatements(subj, pred, obj, includeInferred, new Resource[0]));
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            return this.shapesRepoConnection.hasStatement(subj, pred, obj, includeInferred, new Resource[0]);
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    private boolean isEmpty() {
        return ConnectionHelper.isEmpty(this);
    }

    public ValidationReport revalidate() {
        if (!this.isActive()) {
            throw new IllegalStateException("No active transaction!");
        }
        this.loadCachedNodeShapes();
        this.prepareValidation();
        ValidationReport validate = this.validate(this.nodeShapes, true);
        return new ShaclSailValidationException(validate).getValidationReport();
    }

    private static /* synthetic */ void lambda$serializableValidation$15(SailConnection rec$, Resource x$0, IRI x$1, Value x$2, Resource xva$3) {
        rec$.removeStatements(x$0, x$1, x$2, xva$3);
    }

    private static /* synthetic */ void lambda$serializableValidation$14(SailConnection rec$, Resource x$0, IRI x$1, Value x$2, Resource xva$3) {
        rec$.addStatement(x$0, x$1, x$2, xva$3);
    }

    public static class Settings {
        private ShaclSail.TransactionSettings.ValidationApproach validationApproach = ShaclSail.TransactionSettings.ValidationApproach.Auto;
        private boolean cacheSelectedNodes = false;

        public Settings(boolean cacheSelectNodes, boolean validationEnabled) {
            this.cacheSelectedNodes = cacheSelectNodes;
            if (!validationEnabled) {
                this.validationApproach = ShaclSail.TransactionSettings.ValidationApproach.Disabled;
            }
        }

        public ShaclSail.TransactionSettings.ValidationApproach getValidationApproach() {
            return this.validationApproach;
        }

        public boolean isCacheSelectNodes() {
            return this.cacheSelectedNodes && this.validationApproach != ShaclSail.TransactionSettings.ValidationApproach.Bulk;
        }
    }
}

