/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.OrderIterator;

public class LimitedSizeOrderIteration
extends OrderIterator {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, AtomicLong used, long maxSize) {
        this(iter, comparator, Integer.MAX_VALUE, false, used, maxSize);
    }

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct, AtomicLong used, long maxSize) {
        super(iter, comparator, limit, distinct);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected void increment() throws QueryEvaluationException {
        if (this.used.incrementAndGet() > this.maxSize) {
            throw new QueryEvaluationException("Size limited reached inside order operator query, max size is:" + this.maxSize);
        }
    }

    @Override
    protected void decrement(int amount) throws QueryEvaluationException {
        this.used.getAndAdd(-amount);
    }
}

