/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

public class PDEXMLHelper {
    private PDEXMLHelper() {
    }

    public static String getWritableString(String source) {
        if (source == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            char character = source.charAt(i);
            switch (character) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(character);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getWritableAttributeString(String source) {
        if (source == null) {
            return "";
        }
        source = source.trim();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            char character = source.charAt(i);
            switch (character) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\'': {
                    buffer.append("&apos;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '\r': {
                    buffer.append("&#x0D;");
                    break;
                }
                case '\n': {
                    buffer.append("&#x0A;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

