/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.debug;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.persistence.plain.IPlainTextPersistenceExtension;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.debug.BreakpointResource;
import org.eclipse.rcptt.debug.DebugContext;
import org.eclipse.rcptt.debug.DebugContextAdapter;
import org.eclipse.rcptt.debug.Launch;
import org.eclipse.rcptt.debug.LaunchConfiguration;
import org.eclipse.rcptt.debug.LaunchType;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;

public class DebugContextPlainExtension
implements IPlainTextPersistenceExtension {
    private static final String DEBUG_BREAKPOINTS = "debug.breakpoints";
    private static final String DEBUG_LAUNCHCONFIGURATION = ".debug.launchconfiguration";
    private static final String DEBUG_LAUNCHES = "debug.launches";
    private static final String DEBUG_TYPES = "debug.launchtypes";
    private static final String DEBUG_CONTEXT = ".debug.context";
    private static final String DEBUG_LAUNCH = ".debug.launch";
    private static final String DEBUG_LAUNCH_EXCEPTIONS = "Debug-LaunchExceptions";
    private static final String DEBUG_LAUNCH_SHORTCUT_EXCEPTIONS = "Debug-LaunchShortcutExceptions";
    private static final String DEBUG_NO_BREAKPOINTS = "Debug-NoBreakpoints";
    private static final String DEBUG_NO_LAUNCH_SHORTCUTS = "Debug-NoLaunchShortcuts";
    private static final String DEBUG_NO_LAUNCHES = "Debug-NoLaunches";

    private static void readLaunchConfigurations(DebugContext context, PlainTextPersistenceModel plainTextPersistenceModel) {
        EList<LaunchType> types = context.getLaunchTypes();
        types.clear();
        for (EObject eObject2 : DebugContextPlainExtension.read(plainTextPersistenceModel, DEBUG_TYPES)) {
            if (!(eObject2 instanceof LaunchType)) continue;
            types.add((Object)((LaunchType)EcoreUtil.copy((EObject)eObject2)));
        }
        DebugContextAdapter adapter = new DebugContextAdapter(context);
        String[] stringArray = plainTextPersistenceModel.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.endsWith(DEBUG_LAUNCHCONFIGURATION)) {
                for (EObject eObject3 : DebugContextPlainExtension.read(plainTextPersistenceModel, file)) {
                    LaunchConfiguration conf = (LaunchConfiguration)EcoreUtil.copy((EObject)eObject3);
                    adapter.getLaunchType(conf.getTypeId()).getConfigurations().add((Object)conf);
                }
            }
            ++n2;
        }
    }

    private static void writeLaunchConfigurations(DebugContext eObject, PlainTextPersistenceModel plainTextPersistenceModel) {
        ArrayList<LaunchType> toWrite = new ArrayList<LaunchType>();
        for (LaunchType type : eObject.getLaunchTypes()) {
            LaunchType copy = (LaunchType)EcoreUtil.copy((EObject)type);
            copy.getConfigurations().clear();
            toWrite.add(copy);
        }
        DebugContextPlainExtension.write(plainTextPersistenceModel, DEBUG_TYPES, toWrite);
        String[] stringArray = plainTextPersistenceModel.getNames();
        int copy = stringArray.length;
        int n = 0;
        while (n < copy) {
            String file = stringArray[n];
            if (file.endsWith(DEBUG_LAUNCHCONFIGURATION)) {
                plainTextPersistenceModel.delete(file);
            }
            ++n;
        }
        for (LaunchType type : eObject.getLaunchTypes()) {
            for (LaunchConfiguration conf : type.getConfigurations()) {
                conf.setTypeId(type.getId());
                DebugContextPlainExtension.write(plainTextPersistenceModel, conf.getName() + DEBUG_LAUNCHCONFIGURATION, (EObject)conf);
            }
        }
    }

    private void readBreakpoints(DebugContext ctx, PlainTextPersistenceModel plainTextPersistenceModel) {
        ctx.getBreakpointResources().clear();
        for (EObject eObject2 : DebugContextPlainExtension.read(plainTextPersistenceModel, DEBUG_BREAKPOINTS)) {
            if (!(eObject2 instanceof BreakpointResource)) continue;
            ctx.getBreakpointResources().add((Object)((BreakpointResource)EcoreUtil.copy((EObject)eObject2)));
        }
    }

    private void readLaunches(DebugContext ctx, PlainTextPersistenceModel plainTextPersistenceModel) {
        ctx.getLaunches().clear();
        DebugContextAdapter adapter = new DebugContextAdapter(ctx);
        for (EObject eObject2 : DebugContextPlainExtension.read(plainTextPersistenceModel, DEBUG_LAUNCHES)) {
            if (!(eObject2 instanceof Launch)) continue;
            Launch launch = (Launch)EcoreUtil.copy((EObject)eObject2);
            LaunchConfiguration conf = adapter.getConfiguration(launch.getConfigurationName());
            launch.setConfiguration(conf);
            assert (launch.getConfiguration().getName() != null);
            ctx.getLaunches().add((Object)launch);
            assert (launch.getConfiguration().getName() != null);
        }
    }

    private void writeBreakpoints(DebugContext ctx, PlainTextPersistenceModel plainTextPersistenceModel) {
        DebugContextPlainExtension.write(plainTextPersistenceModel, DEBUG_BREAKPOINTS, ctx.getBreakpointResources());
    }

    public String getTextContentType(String fName) {
        if (DEBUG_CONTEXT.equals(fName)) {
            return "text/ecl";
        }
        if (fName.endsWith(DEBUG_LAUNCHCONFIGURATION)) {
            return "text/launchconfiguration";
        }
        if (fName.equals(DEBUG_BREAKPOINTS)) {
            return "text/breakpoints";
        }
        if (fName.equals(DEBUG_LAUNCHES)) {
            return "text/launch";
        }
        return null;
    }

    public boolean isContentEntryOptional(EList<EObject> contents) {
        return contents.get(0) instanceof DebugContext;
    }

    public void performObjectPreSaveUpdate(EObject eObject) {
    }

    private static EList<EObject> read(PlainTextPersistenceModel plainModel, String attachment) {
        InputStream rawstream;
        XMIResourceImpl resource;
        block5: {
            resource = new XMIResourceImpl();
            rawstream = null;
            rawstream = plainModel.read(attachment);
            if (rawstream != null) break block5;
            EList eList = resource.getContents();
            FileUtil.safeClose((Closeable)rawstream);
            return eList;
        }
        try {
            try {
                resource.load(rawstream, PersistenceManager.getOptions());
                rawstream.close();
            }
            catch (IOException e) {
                RcpttPlugin.log((Throwable)e);
                FileUtil.safeClose((Closeable)rawstream);
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeClose((Closeable)rawstream);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)rawstream);
        return resource.getContents();
    }

    private void writeLaunches(DebugContext ctx, PlainTextPersistenceModel plainTextPersistenceModel) {
        ArrayList<Launch> list = new ArrayList<Launch>();
        for (Launch launchOriginal : ctx.getLaunches()) {
            assert (launchOriginal.getConfiguration().getName() != null);
            Launch launch = (Launch)EcoreUtil.copy((EObject)launchOriginal);
            assert (launchOriginal.getConfiguration().getName() != null);
            assert (launch.getConfiguration().getName() != null);
            launch.setConfigurationName(launch.getConfiguration().getName());
            launch.setConfiguration(null);
            assert (launchOriginal.getConfiguration().getName() != null);
            list.add(launch);
        }
        DebugContextPlainExtension.write(plainTextPersistenceModel, DEBUG_LAUNCHES, list);
    }

    public void updateAttributes(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> masterAttributes, EObject eObject) {
        if (eObject instanceof DebugContext) {
            DebugContext ctx = (DebugContext)eObject;
            masterAttributes.put(DEBUG_NO_BREAKPOINTS, Boolean.toString(ctx.isNoBreakpoints()));
            masterAttributes.put(DEBUG_NO_LAUNCHES, Boolean.toString(ctx.isNoLaunches()));
            masterAttributes.put(DEBUG_NO_LAUNCH_SHORTCUTS, Boolean.toString(ctx.isNoLaunchShortcuts()));
            if (ctx.getLaunchShortcutExceptions() != null) {
                masterAttributes.put(DEBUG_LAUNCH_SHORTCUT_EXCEPTIONS, ctx.getLaunchShortcutExceptions());
            }
            if (ctx.getLaunchExceptions() != null) {
                masterAttributes.put(DEBUG_LAUNCH_EXCEPTIONS, ctx.getLaunchExceptions());
            }
            DebugContextPlainExtension.writeLaunchConfigurations(ctx, plainTextPersistenceModel);
            this.writeBreakpoints(ctx, plainTextPersistenceModel);
            this.writeLaunches(ctx, plainTextPersistenceModel);
        }
    }

    public void updateMetadata(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> header, EObject eObject) {
        if (eObject instanceof DebugContext) {
            DebugContext ctx = (DebugContext)eObject;
            String value = header.get(DEBUG_NO_BREAKPOINTS);
            if (value != null) {
                ctx.setNoBreakpoints(Boolean.parseBoolean(value));
            }
            if ((value = header.get(DEBUG_NO_LAUNCHES)) != null) {
                ctx.setNoLaunches(Boolean.parseBoolean(value));
            }
            if ((value = header.get(DEBUG_NO_LAUNCH_SHORTCUTS)) != null) {
                ctx.setNoLaunchShortcuts(Boolean.parseBoolean(value));
            }
            if ((value = header.get(DEBUG_LAUNCH_SHORTCUT_EXCEPTIONS)) != null) {
                ctx.setLaunchShortcutExceptions(value);
            }
            if ((value = header.get(DEBUG_LAUNCH_EXCEPTIONS)) != null) {
                ctx.setLaunchExceptions(value);
            }
            DebugContextPlainExtension.readLaunchConfigurations(ctx, plainTextPersistenceModel);
            this.readBreakpoints(ctx, plainTextPersistenceModel);
            this.readLaunches(ctx, plainTextPersistenceModel);
        }
    }

    private static void write(PlainTextPersistenceModel plainModel, String attachment, EObject object) {
        ArrayList<EObject> value = new ArrayList<EObject>();
        value.add(object);
        DebugContextPlainExtension.write(plainModel, attachment, value);
    }

    private static void write(PlainTextPersistenceModel plainModel, String attachment, List<? extends EObject> objects) {
        block6: {
            OutputStream stream = null;
            try {
                try {
                    XMIResourceImpl resource = new XMIResourceImpl();
                    for (EObject eObject : objects) {
                        resource.getContents().add((Object)EcoreUtil.copy((EObject)eObject));
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("ENCODING", "UTF-8");
                    stream = plainModel.store(attachment);
                    resource.save(stream, hashMap);
                }
                catch (IOException e) {
                    RcpttPlugin.log((Throwable)e);
                    FileUtil.safeClose(stream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(stream);
                throw throwable;
            }
            FileUtil.safeClose((Closeable)stream);
        }
    }
}

