/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkTokenScanner;
import org.eclipse.egit.ui.internal.dialogs.ShowWhitespaceAction;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;

public class CommitAndDiffComponent {
    private static final String CSS_CLASS = "org-eclipse-egit-ui-CommitAndDiffComponent";
    private ScrolledComposite commentAndDiffScrolledComposite;
    private Composite commentAndDiffComposite;
    private CommitMessageViewer commentViewer;
    private DiffViewer diffViewer;
    private Point commentCaret = new Point(0, 0);
    private Point diffCaret = new Point(0, 0);

    public CommitAndDiffComponent(Composite parent, IWorkbenchPartSite site) {
        this.commentAndDiffScrolledComposite = new ScrolledComposite(parent, 768);
        this.commentAndDiffComposite = new Composite((Composite)this.commentAndDiffScrolledComposite, 0);
        this.commentAndDiffScrolledComposite.setContent((Control)this.commentAndDiffComposite);
        this.commentAndDiffComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.commentViewer = new CommitMessageViewer(this.commentAndDiffComposite, site);
        this.commentViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.commentViewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                CommitAndDiffComponent.this.commentCaret = new Point(0, 0);
                CommitAndDiffComponent.this.resizeCommentAndDiffScrolledComposite();
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }
        });
        final StyledText commentWidget = this.commentViewer.getTextWidget();
        commentWidget.addVerifyKeyListener(event -> {
            int offset = commentWidget.getCaretOffset();
            this.commentCaret = new Point(commentWidget.getLineAtOffset(offset), offset);
        });
        commentWidget.addCaretListener(event -> {
            Point location = commentWidget.getLocationAtOffset(event.caretOffset);
            this.scrollCommentAndDiff(location, commentWidget.getLineHeight(event.caretOffset));
        });
        this.commentAndDiffComposite.setBackground(this.commentViewer.getControl().getBackground());
        this.commentAndDiffScrolledComposite.setBackground(this.commentViewer.getControl().getBackground());
        HyperlinkSourceViewer.Configuration configuration = new HyperlinkSourceViewer.Configuration(EditorsUI.getPreferenceStore()){

            public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                return 0;
            }

            @Override
            protected IHyperlinkDetector[] internalGetHyperlinkDetectors(ISourceViewer sourceViewer) {
                IHyperlinkDetector[] registered = super.internalGetHyperlinkDetectors(sourceViewer);
                if (registered == null) {
                    return new IHyperlinkDetector[]{new CommitMessageViewer.KnownHyperlinksDetector()};
                }
                IHyperlinkDetector[] result = new IHyperlinkDetector[registered.length + 1];
                System.arraycopy(registered, 0, result, 0, registered.length);
                result[registered.length] = new CommitMessageViewer.KnownHyperlinksDetector();
                return result;
            }

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return new String[]{"__dftl_partition_content_type", "__egit_commit_msg_header", "__egit_commit_msg_footer"};
            }

            public IPresentationReconciler getPresentationReconciler(ISourceViewer viewer) {
                PresentationReconciler reconciler = new PresentationReconciler();
                reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(viewer));
                DefaultDamagerRepairer hyperlinkDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer));
                reconciler.setDamager((IPresentationDamager)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                reconciler.setRepairer((IPresentationRepairer)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                Token headerDefault = new Token((Object)new TextAttribute(PlatformUI.getWorkbench().getDisplay().getSystemColor(16)));
                DefaultDamagerRepairer headerDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer, headerDefault));
                reconciler.setDamager((IPresentationDamager)headerDamagerRepairer, "__egit_commit_msg_header");
                reconciler.setRepairer((IPresentationRepairer)headerDamagerRepairer, "__egit_commit_msg_header");
                DefaultDamagerRepairer footerDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new FooterTokenScanner((SourceViewerConfiguration)this, viewer));
                reconciler.setDamager((IPresentationDamager)footerDamagerRepairer, "__egit_commit_msg_footer");
                reconciler.setRepairer((IPresentationRepairer)footerDamagerRepairer, "__egit_commit_msg_footer");
                return reconciler;
            }
        };
        this.commentViewer.configure((SourceViewerConfiguration)configuration);
        this.diffViewer = new DiffViewer(this.commentAndDiffComposite, null, 0);
        this.diffViewer.configure((SourceViewerConfiguration)new DiffViewer.Configuration(EditorsUI.getPreferenceStore()));
        this.diffViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.diffViewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                CommitAndDiffComponent.this.diffCaret = new Point(0, 0);
                CommitAndDiffComponent.this.resizeCommentAndDiffScrolledComposite();
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }
        });
        ActionUtils.UpdateableAction selectAll = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, () -> this.diffViewer.doOperation(7), () -> this.diffViewer.canDoOperation(7));
        ActionUtils.UpdateableAction copy = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> this.diffViewer.doOperation(4), () -> this.diffViewer.canDoOperation(4));
        ActionUtils.setGlobalActions(this.diffViewer.getControl(), new IAction[]{copy, selectAll});
        ShowWhitespaceAction showWhitespaceAction = new ShowWhitespaceAction((ITextViewer)this.diffViewer);
        this.diffViewer.addSelectionChangedListener(e -> copy.update());
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(manager -> {
            if (this.diffViewer.getDocument().getLength() > 0) {
                manager.add((IAction)copy);
                manager.add((IAction)selectAll);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)showWhitespaceAction);
            }
        });
        final StyledText diffWidget = this.diffViewer.getTextWidget();
        diffWidget.setMenu(contextMenu.createContextMenu((Control)diffWidget));
        diffWidget.addDisposeListener(e -> showWhitespaceAction.dispose());
        diffWidget.addVerifyKeyListener(event -> {
            int offset = diffWidget.getCaretOffset();
            this.diffCaret = new Point(diffWidget.getLineAtOffset(offset), offset);
        });
        diffWidget.addCaretListener(event -> {
            Point location = diffWidget.getLocationAtOffset(event.caretOffset);
            location.y += this.diffViewer.getControl().getLocation().y;
            this.scrollCommentAndDiff(location, diffWidget.getLineHeight(event.caretOffset));
        });
        this.commentAndDiffScrolledComposite.addControlListener((ControlListener)new Resizer(this, (Control)this.commentAndDiffScrolledComposite){

            @Override
            public void controlResized(ControlEvent e) {
                if (commentViewer.getTextWidget().getWordWrap()) {
                    super.controlResized(e);
                }
            }
        });
        commentWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int chars;
                if (diffWidget.getCharCount() == 0) {
                    return;
                }
                if (e.keyCode == 0x1000002) {
                    int lastLine = commentWidget.getLineCount() - 1;
                    if (CommitAndDiffComponent.this.commentCaret.x == lastLine && commentWidget.getLineAtOffset(commentWidget.getCaretOffset()) == lastLine) {
                        diffWidget.setFocus();
                        diffWidget.setCaretOffset(0);
                    }
                } else if (e.keyCode == 0x1000004 && CommitAndDiffComponent.this.commentCaret.y == (chars = commentWidget.getCharCount()) && commentWidget.getCaretOffset() == chars) {
                    diffWidget.setFocus();
                    diffWidget.setCaretOffset(0);
                }
            }
        });
        diffWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    if (CommitAndDiffComponent.this.diffCaret.x == 0 && diffWidget.getLineAtOffset(diffWidget.getCaretOffset()) == 0) {
                        commentWidget.setFocus();
                        commentWidget.setCaretOffset(commentWidget.getOffsetAtLine(commentWidget.getLineCount() - 1));
                    }
                } else if (e.keyCode == 0x1000003 && CommitAndDiffComponent.this.diffCaret.y == 0 && diffWidget.getCaretOffset() == 0) {
                    commentWidget.setFocus();
                    commentWidget.setCaretOffset(commentWidget.getCharCount());
                }
            }
        });
        UIUtils.setCssClass((Widget)commentWidget, CSS_CLASS);
        UIUtils.setCssClass((Widget)diffWidget, CSS_CLASS);
    }

    public Control getControl() {
        return this.commentAndDiffScrolledComposite;
    }

    public DiffViewer getDiffViewer() {
        return this.diffViewer;
    }

    public CommitMessageViewer getCommitViewer() {
        return this.commentViewer;
    }

    public void setWrap(boolean wrap) {
        if (Display.getCurrent() == null) {
            StyledText text = this.commentViewer.getTextWidget();
            if (!text.isDisposed()) {
                text.getDisplay().asyncExec(() -> {
                    if (text.isDisposed()) {
                        return;
                    }
                    this.internalSetWrap(wrap);
                });
            }
        } else {
            this.internalSetWrap(wrap);
        }
    }

    private void internalSetWrap(boolean wrap) {
        this.commentViewer.getTextWidget().setWordWrap(wrap);
        this.diffViewer.getTextWidget().setWordWrap(wrap);
        this.resizeCommentAndDiffScrolledComposite();
    }

    private void resizeCommentAndDiffScrolledComposite() {
        Point size;
        StyledText text;
        if (this.commentAndDiffComposite.isDisposed()) {
            return;
        }
        long start = 0L;
        int lines = 0;
        boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (trace) {
            IDocument document = this.diffViewer.getDocument();
            lines = document != null ? document.getNumberOfLines() : 0;
            System.out.println("Lines: " + lines);
            if (lines > 1) {
                new Exception("resizeCommentAndDiffScrolledComposite").printStackTrace(System.out);
            }
            start = System.currentTimeMillis();
        }
        if ((text = this.commentViewer.getTextWidget()) == null) {
            size = new Point(0, 0);
        } else if (text.getWordWrap()) {
            Rectangle minSize = this.commentAndDiffScrolledComposite.getClientArea();
            size = this.commentAndDiffComposite.computeSize(minSize.width, -1);
        } else {
            size = this.commentAndDiffComposite.computeSize(-1, -1);
        }
        this.commentAndDiffComposite.setSize(size);
        this.commentAndDiffComposite.layout();
        if (trace) {
            long stop = System.currentTimeMillis();
            long time = stop - start;
            long lps = (long)(lines * 1000) / (time + 1L);
            System.out.println("Resize + diff: " + time + " ms, line/s: " + lps);
        }
    }

    private void scrollCommentAndDiff(Point location, int lineHeight) {
        Rectangle size = this.commentAndDiffScrolledComposite.getBounds();
        ScrollBar bar = this.commentAndDiffScrolledComposite.getVerticalBar();
        if (bar != null && bar.isVisible()) {
            size.width = Math.max(0, size.width - bar.getSize().x);
        }
        if ((bar = this.commentAndDiffScrolledComposite.getHorizontalBar()) != null && bar.isVisible()) {
            size.height = Math.max(0, size.height - bar.getSize().y);
        }
        Point topLeft = this.commentAndDiffScrolledComposite.getOrigin();
        size.x = topLeft.x;
        size.y = topLeft.y;
        if (location.y >= size.y) {
            location.y += lineHeight;
        }
        if (!size.contains(location)) {
            int left = size.x;
            int top = size.y;
            int minScroll = size.width / 4;
            if (location.x < left) {
                left = Math.max(0, left - Math.max(left - location.x, minScroll));
            } else if (location.x > left + size.width) {
                int maxWidth = this.commentAndDiffComposite.getSize().x;
                int right = Math.max(location.x, left + size.width + minScroll);
                left = Math.min(right, maxWidth) - size.width;
            }
            if (location.y < top) {
                top = location.y;
            } else if (location.y > top + size.height) {
                top = location.y - size.height;
            }
            this.commentAndDiffScrolledComposite.setOrigin(left, top);
        }
    }

    private static class FooterTokenScanner
    extends HyperlinkTokenScanner {
        private static final Pattern ITALIC_LINE = Pattern.compile("^[A-Z](?:[A-Za-z]+-)+by: ");
        private Object defaultSettings;
        private IToken italicToken = this.italic();

        public FooterTokenScanner(SourceViewerConfiguration configuration, ISourceViewer viewer) {
            super(configuration, viewer);
        }

        @Override
        protected IToken scanToken() {
            try {
                String line;
                Matcher m;
                IRegion region = this.document.getLineInformationOfOffset(this.currentOffset);
                if (this.currentOffset == region.getOffset() && (m = ITALIC_LINE.matcher(line = this.document.get(this.currentOffset, region.getLength()))).find()) {
                    this.currentOffset = Math.min(this.endOfRange, this.currentOffset + region.getLength());
                    return this.italic();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        private IToken italic() {
            Object defaults = this.defaultToken.getData();
            if (!Objects.equals(defaults, this.defaultSettings) || this.italicToken == null) {
                TextAttribute italic;
                this.defaultSettings = defaults;
                if (defaults instanceof TextAttribute) {
                    TextAttribute defaultAttribute = (TextAttribute)defaults;
                    int style = defaultAttribute.getStyle() ^ 2;
                    italic = new TextAttribute(defaultAttribute.getForeground(), defaultAttribute.getBackground(), style, defaultAttribute.getFont());
                } else {
                    italic = new TextAttribute(null, null, 2);
                }
                this.italicToken = new Token((Object)italic);
            }
            return this.italicToken;
        }
    }

    private class Resizer
    extends ControlAdapter
    implements Runnable {
        private final Control control;
        private long lastEventTime;

        Resizer(Control control) {
            this.control = control;
        }

        public void controlResized(ControlEvent e) {
            this.lastEventTime = System.currentTimeMillis();
            this.schedule();
        }

        private void schedule() {
            this.control.getDisplay().timerExec(300, (Runnable)this);
        }

        @Override
        public void run() {
            if (this.control.isDisposed()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastEventTime > 300L) {
                CommitAndDiffComponent.this.resizeCommentAndDiffScrolledComposite();
            } else {
                this.schedule();
            }
        }
    }
}

