/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;

public class TargetMetadataCollector {
    public static URI[] getMetadataRepositories(ITargetDefinition definition) throws CoreException {
        if (definition == null) {
            ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
            if (service == null) {
                return null;
            }
            definition = service.getWorkspaceTargetDefinition();
        }
        HashSet<URI> repos = new HashSet<URI>();
        ITargetLocation[] containers = definition.getTargetLocations();
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation currentContainer = iTargetLocationArray[n2];
                if (currentContainer instanceof ProfileBundleContainer) {
                    ProfileBundleContainer profileContainer = (ProfileBundleContainer)currentContainer;
                    File profileLocation = profileContainer.getProfileFileLocation();
                    if (profileLocation != null) {
                        repos.add(profileLocation.toURI());
                    }
                } else if (currentContainer instanceof IUBundleContainer) {
                    IUBundleContainer bundleContainer = (IUBundleContainer)currentContainer;
                    for (URI location : bundleContainer.getRepositories()) {
                        if (!URIUtil.isFileURI((URI)location)) continue;
                        repos.add(location);
                    }
                }
                ++n2;
            }
        }
        return repos.toArray(new URI[repos.size()]);
    }
}

