/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class ApiImageDescriptor
extends CompositeImageDescriptor {
    public static final int ERROR = 1;
    public static final int SUCCESS = 2;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public ApiImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(this.getBaseImage());
            this.setSize(new Point(data.getWidth(), data.getHeight()));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ApiImageDescriptor)) {
            return false;
        }
        ApiImageDescriptor other = (ApiImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        CompositeImageDescriptor.CachedImageDataProvider bg = this.createCachedImageDataProvider(this.getBaseImage());
        this.drawImage((ImageDataProvider)bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        String imageDescriptorKey;
        int flags = this.getFlags();
        if ((flags & 1) != 0) {
            imageDescriptorKey = "IMG_OVR_ERROR";
        } else if ((flags & 2) != 0) {
            imageDescriptorKey = "IMG_OVR_SUCCESS";
        } else {
            return;
        }
        ImageDescriptor imageDescriptor = ApiUIPlugin.getImageDescriptor(imageDescriptorKey);
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(imageDescriptor);
        this.drawImage((ImageDataProvider)data, 0, this.getSize().y - data.getHeight());
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

