/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewDependenciesAction;
import org.eclipse.pde.internal.ui.util.SharedLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class DependencyManagementSection
extends TableSection
implements IPluginModelListener,
IPropertyChangeListener {
    private TableViewer fAdditionalTable;
    private Vector<String> fAdditionalBundles;
    private Action fNewAction;
    private Action fRemoveAction;
    private Action fOpenAction;
    private Action fSortAction;
    private Button fRequireBundleButton;
    private Button fImportPackageButton;
    private IProject fProject;
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int UP_INDEX = 2;
    private static final int DOWN_INDEX = 3;
    private static String ADD = PDEUIMessages.RequiresSection_add;
    private static String REMOVE = PDEUIMessages.RequiresSection_delete;
    private static String OPEN = PDEUIMessages.RequiresSection_open;
    private static String UP = PDEUIMessages.RequiresSection_up;
    private static String DOWN = PDEUIMessages.RequiresSection_down;

    public DependencyManagementSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 34, new String[]{ADD, REMOVE, UP, DOWN});
        IBuildEntry entry;
        IBuildModel model = this.getBuildModel(false);
        if (model != null && (entry = model.getBuild().getEntry("additional.bundles")) != null && entry.getTokens().length > 0) {
            this.getSection().setExpanded(true);
        }
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        FormText text = toolkit.createFormText((Composite)section, true);
        text.setText(PDEUIMessages.SecondaryBundlesSection_desc, false, false);
        section.setDescriptionControl((Control)text);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fAdditionalTable = tablePart.getTableViewer();
        this.fAdditionalTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fAdditionalTable.setLabelProvider((IBaseLabelProvider)new SecondaryTableLabelProvider());
        GridData gd = (GridData)this.fAdditionalTable.getTable().getLayoutData();
        gd.heightHint = 150;
        this.fAdditionalTable.getTable().setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        FormText resolveText = toolkit.createFormText(container, true);
        resolveText.setText(PDEUIMessages.SecondaryBundlesSection_resolve, true, true);
        resolveText.setLayoutData((Object)gd);
        resolveText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DependencyManagementSection.this.doAddDependencies();
            }
        });
        Composite comp = toolkit.createComposite(container);
        comp.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        this.fRequireBundleButton = toolkit.createButton(comp, "Require-Bundle", 16);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fRequireBundleButton.setLayoutData((Object)gd);
        this.fRequireBundleButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.savePreferences()));
        this.fImportPackageButton = toolkit.createButton(comp, "Import-Package", 16);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fImportPackageButton.setLayoutData((Object)gd);
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(768));
        section.setText(PDEUIMessages.SecondaryBundlesSection_title);
        this.createSectionToolbar(section, toolkit);
        this.initialize();
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fSortAction = new SortAction((StructuredViewer)this.getTablePart().getTableViewer(), PDEUIMessages.RequiresSection_sortAlpha, null, null, this);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void savePreferences() {
        if (this.fProject == null) {
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            IResource resource = model.getUnderlyingResource();
            if (resource == null) {
                return;
            }
            this.fProject = resource.getProject();
        }
        IEclipsePreferences pref = new ProjectScope(this.fProject).getNode("org.eclipse.pde.core");
        if (this.fImportPackageButton.getSelection()) {
            pref.putBoolean("resolve.requirebundle", false);
        } else {
            pref.remove("resolve.requirebundle");
        }
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void initialize() {
        try {
            IResource resource;
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            this.fAdditionalTable.setInput((Object)model.getPluginBase());
            EditableTablePart part = this.getTablePart();
            part.setButtonEnabled(0, model.isEditable());
            part.setButtonEnabled(1, false);
            part.setButtonEnabled(2, false);
            part.setButtonEnabled(3, false);
            IBuildModel build = this.getBuildModel(false);
            if (build != null) {
                build.addModelChangedListener((IModelChangedListener)this);
            }
            if ((resource = model.getUnderlyingResource()) == null) {
                return;
            }
            this.fProject = resource.getProject();
            IEclipsePreferences pref = new ProjectScope(this.fProject).getNode("org.eclipse.pde.core");
            if (pref != null) {
                boolean useRequireBundle = pref.getBoolean("resolve.requirebundle", true);
                this.fRequireBundleButton.setSelection(useRequireBundle);
                this.fImportPackageButton.setSelection(!useRequireBundle);
            }
            PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.fAdditionalTable.getStructuredSelection();
        manager.add((IAction)this.fNewAction);
        manager.add((IAction)this.fOpenAction);
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public void refresh() {
        this.fAdditionalBundles = null;
        if (!this.fAdditionalTable.getControl().isDisposed()) {
            this.fAdditionalTable.refresh();
        }
        super.refresh();
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection sel) {
        this.handleOpen((ISelection)sel);
    }

    private void handleOpen(ISelection sel) {
        Object obj;
        IPluginModelBase base;
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1 && (base = PluginRegistry.findModel((String)((String)(obj = ssel.getFirstElement())))) != null) {
            ManifestEditor.open(base.getPluginBase(), false);
        }
    }

    private IBuildModel getBuildModel(boolean createIfMissing) {
        InputContext context = this.getPage().getPDEEditor().getContextManager().findContext("build-context");
        if (context == null) {
            if (createIfMissing) {
                IFile buildFile = PDEProject.getBuildProperties((IProject)this.getPage().getPDEEditor().getCommonProject());
                try {
                    buildFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    return null;
                }
                FileEditorInput in = new FileEditorInput(buildFile);
                PDEFormEditor editor = this.getPage().getPDEEditor();
                context = new BuildInputContext(this.getPage().getPDEEditor(), (IEditorInput)in, false);
                editor.getContextManager().putContext((IEditorInput)in, context);
            } else {
                return null;
            }
        }
        return (IBuildModel)context.getModel();
    }

    private void makeActions() {
        this.fNewAction = new Action(ADD){

            public void run() {
                DependencyManagementSection.this.handleNew();
            }
        };
        this.fOpenAction = new Action(OPEN){

            public void run() {
                DependencyManagementSection.this.handleOpen((ISelection)DependencyManagementSection.this.fAdditionalTable.getStructuredSelection());
            }
        };
        this.fRemoveAction = new Action(REMOVE){

            public void run() {
                DependencyManagementSection.this.handleRemove();
            }
        };
    }

    private void handleNew() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getAvailablePlugins(), true);
        dialog.create();
        if (dialog.open() == 0) {
            IBuildModel model = this.getBuildModel(true);
            IBuild build = model.getBuild();
            IBuildEntry entry = build.getEntry("additional.bundles");
            try {
                Object[] models;
                if (entry == null) {
                    entry = model.getFactory().createEntry("additional.bundles");
                    build.add(entry);
                }
                Object[] objectArray = models = dialog.getResult();
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    Object m = objectArray[n2];
                    IPluginModel pmodel = (IPluginModel)m;
                    entry.addToken(pmodel.getPlugin().getId());
                    ++n2;
                }
                this.markDirty();
                PDEPreferencesManager store = PDELaunchingPlugin.getDefault().getPreferenceManager();
                store.setDefault("Preferences.MainPage.automanageDependencies", true);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private IPluginModelBase[] getAvailablePlugins() {
        IProject currentProj;
        IPluginModelBase model;
        IPluginModelBase[] plugins = PluginRegistry.getActiveModels((boolean)false);
        HashSet<String> currentPlugins = new HashSet<String>();
        if (this.fAdditionalBundles != null) {
            currentPlugins.addAll(this.fAdditionalBundles);
        }
        if ((model = PluginRegistry.findModel((IProject)(currentProj = this.getPage().getPDEEditor().getCommonProject()))) != null) {
            currentPlugins.add(model.getPluginBase().getId());
            if (model.isFragmentModel()) {
                currentPlugins.add(((IFragmentModel)model).getFragment().getPluginId());
            }
        }
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < plugins.length) {
            if (!currentPlugins.contains(plugins[i].getPluginBase().getId())) {
                result.add(plugins[i]);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fAdditionalTable.getStructuredSelection();
        IBuild build = this.getBuildModel(false).getBuild();
        IBuildEntry entry = build.getEntry("additional.bundles");
        Iterator it = ssel.iterator();
        try {
            while (it.hasNext()) {
                String pluginName = (String)it.next();
                entry.removeToken(pluginName);
            }
            if (entry.getTokens().length == 0) {
                build.remove(entry);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.refresh();
        this.markDirty();
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    private void updateButtons() {
        EditableTablePart part = this.getTablePart();
        Table table = this.fAdditionalTable.getTable();
        int index = table.getSelectionIndex();
        part.setButtonEnabled(1, index != -1);
        this.updateUpDownButtons();
    }

    @Override
    public void modelChanged(final IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        UIJob job = new UIJob("Update required bundles"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object changedObject = event.getChangedObjects()[0];
                if (changedObject instanceof IBuildEntry && ((IBuildEntry)changedObject).getName().equals("additional.bundles")) {
                    DependencyManagementSection.this.refresh();
                    DependencyManagementSection.this.updateButtons();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        HashSet<String> secondaryDepSet = null;
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            String secondaryDep;
            Object sourceObject = objectArray[n2];
            if (!(sourceObject instanceof String)) {
                return false;
            }
            if (secondaryDepSet == null) {
                secondaryDepSet = this.createSecondaryDepSet();
            }
            if (secondaryDepSet.contains(secondaryDep = (String)sourceObject)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private HashSet<String> createSecondaryDepSet() {
        HashSet<String> secondaryDepSet = new HashSet<String>();
        IBuildModel buildModel = this.getBuildModel(true);
        if (buildModel == null) {
            return secondaryDepSet;
        }
        IBuild build = buildModel.getBuild();
        IBuildEntry entry = build.getEntry("additional.bundles");
        if (entry == null) {
            return secondaryDepSet;
        }
        String[] tokens = entry.getTokens();
        if (tokens.length == 0) {
            return secondaryDepSet;
        }
        Collections.addAll(secondaryDepSet, tokens);
        return secondaryDepSet;
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        IBuildModel buildModel = this.getBuildModel(true);
        if (buildModel == null) {
            return;
        }
        IBuild build = buildModel.getBuild();
        IBuildEntry entry = build.getEntry("additional.bundles");
        try {
            Object[] objectArray = sourceObjects;
            int n = sourceObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object sourceObject = objectArray[n2];
                if (sourceObject instanceof String) {
                    if (entry == null) {
                        entry = buildModel.getFactory().createEntry("additional.bundles");
                        build.add(entry);
                    }
                    entry.addToken((String)sourceObject);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void doAddDependencies() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IBundlePluginModelBase) {
            IProject proj = this.getPage().getPDEEditor().getCommonProject();
            IBundlePluginModelBase bmodel = (IBundlePluginModelBase)model;
            AddNewDependenciesAction action = new AddNewDependenciesAction(proj, bmodel);
            action.run();
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        super.dispose();
    }

    public void modelsChanged(PluginModelDelta delta) {
        this.fAdditionalBundles = null;
        Control control = this.fAdditionalTable.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    this.fAdditionalTable.refresh();
                }
            });
        }
    }

    private void handleUp() {
        this.movePlugins(-1);
    }

    private void handleDown() {
        this.movePlugins(1);
    }

    private void updateUpDownButtons() {
        EditableTablePart tablePart = this.getTablePart();
        if (this.fSortAction.isChecked()) {
            tablePart.setButtonEnabled(2, false);
            tablePart.setButtonEnabled(3, false);
            return;
        }
        Table table = this.fAdditionalTable.getTable();
        int index = table.getSelectionIndex();
        int totalElems = table.getItemCount();
        boolean canMove = totalElems > 1 && table.getSelectionCount() == 1;
        tablePart.setButtonEnabled(2, canMove && index > 0);
        tablePart.setButtonEnabled(3, canMove && index >= 0 && index < totalElems - 1);
    }

    private void movePlugins(int newOffset) {
        IBuild build;
        IBuildEntry entry;
        int index = this.fAdditionalTable.getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        IBuildModel model = this.getBuildModel(false);
        if (model != null && (entry = (build = model.getBuild()).getEntry("additional.bundles")) instanceof BuildEntry) {
            ((BuildEntry)entry).swap(index, index + newOffset);
        }
        this.updateButtons();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fSortAction.equals(event.getSource()) && "result".equals(event.getProperty())) {
            this.updateUpDownButtons();
        }
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    @Override
    protected boolean isDragAndDropEnabled() {
        return true;
    }

    @Override
    public boolean canDragMove(Object[] sourceObjects) {
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return false;
        }
        return !this.isTreeViewerSorted();
    }

    private boolean validateDragMoveSanity(Object[] sourceObjects) {
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length != 1) {
            return false;
        }
        return sourceObjects[0] instanceof String;
    }

    @Override
    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            return false;
        }
        String sourcePlugin = (String)sourceObjects[0];
        String targetPlugin = (String)targetObject;
        BuildEntry entry = this.getSecondaryDepBuildEntry();
        if (entry == null) {
            return false;
        }
        if (targetLocation == 1) {
            String previousPlugin = entry.getPreviousToken(targetPlugin);
            return !sourcePlugin.equals(previousPlugin);
        }
        if (targetLocation == 2) {
            String nextPlugin = entry.getNextToken(targetPlugin);
            return !sourcePlugin.equals(nextPlugin);
        }
        if (targetLocation == 3) {
            return false;
        }
        return false;
    }

    private BuildEntry getSecondaryDepBuildEntry() {
        IBuildModel buildModel = this.getBuildModel(true);
        if (buildModel == null) {
            return null;
        }
        IBuild build = buildModel.getBuild();
        if (build == null) {
            return null;
        }
        IBuildEntry entry = build.getEntry("additional.bundles");
        if (!(entry instanceof BuildEntry)) {
            return null;
        }
        return (BuildEntry)entry;
    }

    private boolean validateDropMoveSanity(Object targetObject, Object[] sourceObjects) {
        if (!(targetObject instanceof String)) {
            return false;
        }
        return this.validateDragMoveSanity(sourceObjects);
    }

    @Override
    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        String sourcePlugin = (String)sourceObjects[0];
        String targetPlugin = (String)targetObject;
        if (targetLocation == 1 || targetLocation == 2) {
            this.doDropMove(sourcePlugin, targetPlugin, targetLocation);
        }
    }

    private void doDropMove(String sourcePlugin, String targetPlugin, int targetLocation) {
        this.doDragRemove();
        BuildEntry entry = this.getSecondaryDepBuildEntry();
        if (entry == null) {
            return;
        }
        int index = entry.getIndexOf(targetPlugin);
        if (index == -1) {
            return;
        }
        int targetIndex = index;
        if (targetLocation == 2) {
            ++targetIndex;
        }
        entry.addToken(sourcePlugin, targetIndex);
    }

    private void doDragRemove() {
        BuildEntry entry = this.getSecondaryDepBuildEntry();
        if (entry == null) {
            return;
        }
        Object[] sourceObjects = this.getDragSourceObjects();
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return;
        }
        String sourcePlugin = (String)sourceObjects[0];
        try {
            entry.removeToken(sourcePlugin);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private boolean isTreeViewerSorted() {
        if (this.fSortAction == null) {
            return false;
        }
        return this.fSortAction.isChecked();
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (DependencyManagementSection.this.fAdditionalBundles == null) {
                return this.createAdditionalBundles();
            }
            return DependencyManagementSection.this.fAdditionalBundles.toArray();
        }

        private IBuildEntry getBuildInfo() {
            IBuildModel model = DependencyManagementSection.this.getBuildModel(false);
            if (model == null) {
                return null;
            }
            IBuild buildObject = model.getBuild();
            IBuildEntry entry = buildObject.getEntry("additional.bundles");
            return entry;
        }

        private Object[] createAdditionalBundles() {
            IBuildEntry entry = this.getBuildInfo();
            try {
                if (entry != null) {
                    String[] tokens = entry.getTokens();
                    DependencyManagementSection.this.fAdditionalBundles = new Vector(tokens.length);
                    String[] stringArray = tokens;
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        DependencyManagementSection.this.fAdditionalBundles.add(token.trim());
                        ++n2;
                    }
                    return DependencyManagementSection.this.fAdditionalBundles.toArray();
                }
                return new Object[0];
            }
            catch (Exception e) {
                PDEPlugin.logException(e);
                return new Object[0];
            }
        }
    }

    class SecondaryTableLabelProvider
    extends SharedLabelProvider {
        SecondaryTableLabelProvider() {
        }

        @Override
        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            String pluginID = obj.toString();
            IPluginModelBase model = PluginRegistry.findModel((String)pluginID);
            if (model == null) {
                return this.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ, 1);
            }
            if (model instanceof IBundlePluginModel || model instanceof WorkspacePluginModel) {
                return this.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ);
            }
            if (model instanceof ExternalPluginModel) {
                return this.get(PDEPluginImages.DESC_PLUGIN_OBJ, 32);
            }
            return null;
        }
    }
}

