/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

public class FindClassResolutionsOperation
implements IRunnableWithProgress {
    String fClassName = null;
    IProject fProject = null;
    AbstractClassResolutionCollector fCollector = null;
    private CompilationUnit fCompilationUnit;

    public FindClassResolutionsOperation(IProject project, String className, AbstractClassResolutionCollector collector) {
        this.fProject = project;
        this.fClassName = className;
        this.fCollector = collector;
    }

    public FindClassResolutionsOperation(IProject project, CompilationUnit cu, String className, AbstractClassResolutionCollector collector) {
        this.fProject = project;
        this.fCompilationUnit = cu;
        this.fClassName = className;
        this.fCollector = collector;
    }

    public void run(IProgressMonitor monitor) {
        HashSet<IPackageFragment> packagesToExport;
        Map<String, ExportPackageDescription> validPackages;
        int idx = this.fClassName.lastIndexOf(46);
        String packageName = idx != -1 ? this.fClassName.substring(0, idx) : null;
        String typeName = this.fClassName.substring(idx + 1);
        if (typeName.length() == 1 && typeName.charAt(0) == '*') {
            typeName = null;
        }
        if ((validPackages = this.getValidPackages(typeName, this.fClassName, packageName, packagesToExport = new HashSet<IPackageFragment>(), monitor)) != null) {
            if (validPackages.isEmpty()) {
                for (IPackageFragment fragment : packagesToExport) {
                    this.fCollector.addExportPackageResolutionModification(fragment);
                }
                return;
            }
            Iterator<Map.Entry<String, ExportPackageDescription>> validPackagesIter = validPackages.entrySet().iterator();
            Set<ExportPackageDescription> visiblePkgs = null;
            boolean allowMultipleFixes = packageName == null;
            while (validPackagesIter.hasNext() && (allowMultipleFixes || !this.fCollector.isDone())) {
                Map.Entry<String, ExportPackageDescription> currentEntry;
                ExportPackageDescription currentPackage;
                if (visiblePkgs == null) {
                    visiblePkgs = this.getVisiblePackages();
                }
                if (visiblePkgs.contains(currentPackage = (currentEntry = validPackagesIter.next()).getValue())) continue;
                this.fCollector.addResolutionModification(this.fProject, currentPackage, this.fCompilationUnit, currentEntry.getKey());
            }
            Set<String> bundleNames = this.getCurrentBundleNames();
            for (Map.Entry<String, ExportPackageDescription> currentEntry : validPackages.entrySet()) {
                ExportPackageDescription currentPackage = currentEntry.getValue();
                BundleDescription desc = currentPackage.getExporter();
                if (desc == null || bundleNames.contains(desc.getName())) continue;
                this.fCollector.addRequireBundleModification(this.fProject, currentPackage, 3, this.fCompilationUnit, currentEntry.getKey());
                bundleNames.add(desc.getName());
            }
        }
    }

    private Map<String, ExportPackageDescription> getValidPackages(String typeName, String qualifiedTypeToImport, String packageName, Set<IPackageFragment> packagesToExport, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        Map<String, ExportPackageDescription> validPackages = null;
        ImportPackageSpecification[] importPkgs = null;
        IPluginModelBase model = PluginRegistry.findModel((IProject)this.fProject);
        if (model != null && model.getBundleDescription() != null) {
            importPkgs = model.getBundleDescription().getImportPackages();
        }
        subMonitor.split(1);
        if (importPkgs != null) {
            if (packageName != null) {
                if (!this.isImportedPackage(packageName, importPkgs)) {
                    validPackages = FindClassResolutionsOperation.getValidPackages(packageName, qualifiedTypeToImport);
                }
                subMonitor.split(1);
            } else {
                validPackages = this.findValidPackagesContainingSimpleType(typeName, importPkgs, packagesToExport, (IProgressMonitor)subMonitor.split(1));
            }
        }
        return validPackages;
    }

    private Map<String, ExportPackageDescription> findValidPackagesContainingSimpleType(String aTypeName, ImportPackageSpecification[] importPkgs, Set<IPackageFragment> packagesToExport, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IPluginModelBase[] activeModels = PluginRegistry.getActiveModels();
        LinkedHashSet<IJavaProject> javaProjects = new LinkedHashSet<IJavaProject>(activeModels.length * 2);
        IPluginModelBase[] iPluginModelBaseArray = activeModels;
        int n = activeModels.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            IPluginModelBase model = iPluginModelBaseArray[n2];
            IResource resource = model.getUnderlyingResource();
            if (resource != null && resource.isAccessible() && (javaProject = JavaCore.create((IProject)resource.getProject())).exists()) {
                javaProjects.add(javaProject);
            }
            ++n2;
        }
        final IJavaProject currentJavaProject = JavaCore.create((IProject)this.fProject);
        javaProjects.remove(currentJavaProject);
        try {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProjects.toArray(new IJavaElement[javaProjects.size()]));
            final HashMap packages = new HashMap();
            final HashMap qualifiedTypeNames = new HashMap();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch aMatch) throws CoreException {
                    IPackageFragment packageFragment;
                    IType type;
                    Object element = aMatch.getElement();
                    if (element instanceof IType && Flags.isPublic((int)(type = (IType)element).getFlags()) && !currentJavaProject.equals(type.getJavaProject()) && (packageFragment = type.getPackageFragment()).exists()) {
                        packages.put(packageFragment.getElementName(), packageFragment);
                        qualifiedTypeNames.put(packageFragment.getElementName(), type.getFullyQualifiedName());
                    }
                }
            };
            SearchPattern typePattern = SearchPattern.createPattern((String)aTypeName, (int)0, (int)0, (int)8);
            if (typePattern == null) {
                return Collections.emptyMap();
            }
            new SearchEngine().search(typePattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, requestor, (IProgressMonitor)subMonitor.split(1));
            if (!packages.isEmpty()) {
                ExportPackageDescription[] knownPackages;
                ExportPackageDescription[] systemPackages;
                HashMap<String, ExportPackageDescription> exportDescriptions = new HashMap<String, ExportPackageDescription>(packages.size());
                ExportPackageDescription[] exportPackageDescriptionArray = systemPackages = PDECore.getDefault().getModelManager().getState().getState().getSystemPackages();
                int n3 = systemPackages.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription systemPackage = exportPackageDescriptionArray[n4];
                    packages.remove(systemPackage.getName());
                    ++n4;
                }
                exportPackageDescriptionArray = importPkgs;
                n3 = importPkgs.length;
                n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription importPackage = exportPackageDescriptionArray[n4];
                    packages.remove(importPackage.getName());
                    ++n4;
                }
                ExportPackageDescription[] exportPackageDescriptionArray2 = knownPackages = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
                int n5 = knownPackages.length;
                n3 = 0;
                while (n3 < n5) {
                    ExportPackageDescription knownPackage = exportPackageDescriptionArray2[n3];
                    if (packages.containsKey(knownPackage.getName())) {
                        exportDescriptions.put((String)qualifiedTypeNames.get(knownPackage.getName()), knownPackage);
                    }
                    ++n3;
                }
                if (exportDescriptions.isEmpty()) {
                    packagesToExport.addAll(packages.values());
                }
                return exportDescriptions;
            }
            return Collections.emptyMap();
        }
        catch (CoreException coreException) {
            return Collections.emptyMap();
        }
    }

    private boolean isImportedPackage(String packageName, ImportPackageSpecification[] importPkgs) {
        ImportPackageSpecification[] importPackageSpecificationArray = importPkgs;
        int n = importPkgs.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importPackage = importPackageSpecificationArray[n2];
            if (importPackage.getName().equals(packageName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Map<String, ExportPackageDescription> getValidPackages(String pkgName, String qualifiedTypeToImport) {
        ExportPackageDescription knownPackage;
        ExportPackageDescription[] knownPackages = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
        HashMap<String, ExportPackageDescription> validPackages = new HashMap<String, ExportPackageDescription>();
        ExportPackageDescription[] exportPackageDescriptionArray = knownPackages;
        int n = knownPackages.length;
        int n2 = 0;
        while (n2 < n) {
            knownPackage = exportPackageDescriptionArray[n2];
            if (knownPackage.getName().equals(pkgName)) {
                validPackages.put(knownPackage.getName(), knownPackage);
            }
            ++n2;
        }
        if (!validPackages.isEmpty()) {
            exportPackageDescriptionArray = knownPackages = PDECore.getDefault().getModelManager().getState().getState().getSystemPackages();
            n = knownPackages.length;
            n2 = 0;
            while (n2 < n) {
                knownPackage = exportPackageDescriptionArray[n2];
                validPackages.remove(knownPackage.getName());
                ++n2;
            }
        }
        HashMap<String, ExportPackageDescription> packages = new HashMap<String, ExportPackageDescription>();
        for (ExportPackageDescription exportPackageDescription : validPackages.values()) {
            packages.put(qualifiedTypeToImport, exportPackageDescription);
        }
        return packages;
    }

    private Set<ExportPackageDescription> getVisiblePackages() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        if (base != null) {
            BundleDescription desc = base.getBundleDescription();
            StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
            ExportPackageDescription[] visiblePkgs = helper.getVisiblePackages(desc);
            HashSet<ExportPackageDescription> set = new HashSet<ExportPackageDescription>();
            Collections.addAll(set, visiblePkgs);
            return set;
        }
        return Collections.emptySet();
    }

    private Set<String> getCurrentBundleNames() {
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.fProject);
        if (base != null) {
            BundleSpecification[] reqBundles;
            HashSet<String> bundleNames = new HashSet<String>();
            BundleSpecification[] bundleSpecificationArray = reqBundles = base.getBundleDescription().getRequiredBundles();
            int n = reqBundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification reqBundle = bundleSpecificationArray[n2];
                bundleNames.add(reqBundle.getName());
                ++n2;
            }
            return bundleNames;
        }
        return Collections.emptySet();
    }

    public static abstract class AbstractClassResolutionCollector {
        public abstract void addResolutionModification(IProject var1, ExportPackageDescription var2);

        public abstract void addResolutionModification(IProject var1, ExportPackageDescription var2, CompilationUnit var3, String var4);

        public Object addExportPackageResolutionModification(IPackageFragment aPackage) {
            IResource packageResource;
            if (aPackage.exists() && (packageResource = aPackage.getResource()) != null) {
                return JavaResolutionFactory.createExportPackageProposal(packageResource.getProject(), aPackage, 1, 100);
            }
            return null;
        }

        public Object addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance) {
            return this.addRequireBundleModification(project, desc, relevance, null, "");
        }

        public Object addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance, CompilationUnit cu, String qualifiedTypeToImport) {
            return JavaResolutionFactory.createRequireBundleProposal(project, desc, 1, relevance, cu, qualifiedTypeToImport);
        }

        public Object addSearchRepositoriesModification(String packageName) {
            return JavaResolutionFactory.createSearchRepositoriesProposal(packageName);
        }

        public boolean isDone() {
            return false;
        }
    }
}

