/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.egit.ui.internal.properties.TagPropertySource;
import org.eclipse.egit.ui.internal.repository.BranchPropertySource;
import org.eclipse.egit.ui.internal.repository.RepositoryPropertySource;
import org.eclipse.egit.ui.internal.repository.RepositoryRemotePropertySource;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoryPropertySourceProvider
implements IPropertySourceProvider {
    private final PropertySheetPage myPage;
    private Object lastObject;
    private IPropertySource lastRepositorySource;
    private SourceType lastSourceType = SourceType.UNDEFINED;
    private ListenerHandle listenerHandle;
    private DisposeListener disposeListener;

    public RepositoryPropertySourceProvider(PropertySheetPage page) {
        this.myPage = page;
    }

    private void registerDisposal() {
        if (this.disposeListener != null) {
            return;
        }
        Control control = this.myPage.getControl();
        if (control == null) {
            return;
        }
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RepositoryPropertySourceProvider.this.removeListener();
            }
        };
        control.addDisposeListener(this.disposeListener);
    }

    private void removeListener() {
        ListenerHandle handle = this.listenerHandle;
        if (handle != null) {
            handle.remove();
        }
    }

    private void refreshPage() {
        this.lastObject = null;
        this.myPage.getSite().getShell().getDisplay().asyncExec(() -> this.myPage.setPropertySourceProvider((IPropertySourceProvider)this));
    }

    public IPropertySource getPropertySource(Object object) {
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        if (object == this.lastObject) {
            return this.lastRepositorySource;
        }
        if (!(object instanceof RepositoryTreeNode)) {
            return null;
        }
        if (((RepositoryTreeNode)object).getRepository() == null) {
            return null;
        }
        this.registerDisposal();
        this.removeListener();
        RepositoryTreeNode node = (RepositoryTreeNode)object;
        this.listenerHandle = node.getRepository().getListenerList().addConfigChangedListener(event -> this.refreshPage());
        if (node.getType() == RepositoryTreeNodeType.REPO) {
            this.lastObject = object;
            this.checkChangeType(SourceType.REPOSITORY);
            this.lastRepositorySource = new RepositoryPropertySource((Repository)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        if (node.getType() == RepositoryTreeNodeType.REMOTE) {
            this.lastObject = object;
            this.checkChangeType(SourceType.REMOTE);
            this.lastRepositorySource = new RepositoryRemotePropertySource(node.getRepository().getConfig(), (String)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        if (node.getType() == RepositoryTreeNodeType.FETCH || node.getType() == RepositoryTreeNodeType.PUSH) {
            return this.getPropertySource(node.getParent());
        }
        if (node.getType() == RepositoryTreeNodeType.REF) {
            this.lastObject = object;
            Ref ref = (Ref)node.getObject();
            if (ref.getName().startsWith("refs/heads/") || ref.getName().startsWith("refs/remotes/")) {
                this.checkChangeType(SourceType.BRANCH);
                Repository repository = (Repository)Adapters.adapt((Object)node, Repository.class);
                this.lastRepositorySource = new BranchPropertySource(repository, ref.getName(), this.myPage);
                return this.lastRepositorySource;
            }
            return null;
        }
        if (node.getType() == RepositoryTreeNodeType.TAG) {
            this.lastObject = object;
            this.checkChangeType(SourceType.TAG);
            this.lastRepositorySource = new TagPropertySource(node.getRepository(), (Ref)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        return null;
    }

    private void checkChangeType(SourceType type) {
        if (this.lastSourceType != type) {
            IActionBars bars = this.myPage.getSite().getActionBars();
            IToolBarManager mgr = bars.getToolBarManager();
            boolean update = false;
            update |= mgr.remove("ChangeMode") != null;
            update |= mgr.remove("SingleValueToggle") != null;
            update |= mgr.remove("Edit") != null;
            if (update |= mgr.remove("EditBranch") != null) {
                bars.updateActionBars();
            }
        }
        this.lastSourceType = type;
    }

    private static enum SourceType {
        UNDEFINED,
        REPOSITORY,
        REMOTE,
        BRANCH,
        TAG;

    }
}

