/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.ApiMarkerResolutionGenerator;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class RemoveFilterProblemResolution
extends WorkbenchMarkerResolution {
    IApiProblemFilter fFilter = null;
    private IMarker fMarker = null;
    boolean plural = false;

    public RemoveFilterProblemResolution(IApiProblemFilter filter, IMarker marker) {
        this.fFilter = filter;
        this.fMarker = marker;
    }

    public String getDescription() {
        return NLS.bind((String)MarkerMessages.RemoveFilterProblemResolution_removes_selected_problem_filter, (Object)MarkerUtilities.getMessage((IMarker)this.fMarker));
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_REMOVE");
    }

    public String getLabel() {
        if (this.plural) {
            return MarkerMessages.RemoveFilterProblemResolution_remove_unused_filters;
        }
        return MarkerMessages.RemoveFilterProblemResolution_remove_unused_filter;
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getLabel(), (int)(markers.length * 2 + 1));
        IApiProblemFilter filter = this.fFilter;
        IApiComponent component = null;
        HashMap<IApiComponent, HashSet<IApiProblemFilter>> map = new HashMap<IApiComponent, HashSet<IApiProblemFilter>>();
        Set<Object> filters = null;
        HashSet<IResource> resources = new HashSet<IResource>(markers.length);
        IResource resource = null;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            localmonitor.split(1);
            filter = ApiMarkerResolutionGenerator.resolveFilter(marker);
            if (filter != null) {
                resource = marker.getResource();
                component = ApiBaselineManager.getManager().getWorkspaceBaseline().getApiComponent(resource.getProject());
                if (component instanceof ProjectComponent) {
                    filters = (Set)map.get(component);
                    if (filters == null) {
                        filters = new HashSet<IApiProblemFilter>();
                        map.put(component, (HashSet<IApiProblemFilter>)filters);
                    }
                    filters.add(filter);
                    resources.add(resource);
                }
            }
            ++n2;
        }
        localmonitor.setWorkRemaining(map.size());
        for (Map.Entry entry : map.entrySet()) {
            try {
                component = (IApiComponent)entry.getKey();
                filters = (HashSet<IApiProblemFilter>)entry.getValue();
                IApiFilterStore store = component.getFilterStore();
                store.removeFilters(filters.toArray(new IApiProblemFilter[filters.size()]));
            }
            catch (CoreException ce) {
                ApiPlugin.log((Throwable)ce);
            }
            localmonitor.split(1);
        }
        HashSet<IProject> pjs = new HashSet<IProject>();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            try {
                resource = (IResource)iter.next();
                pjs.add(resource.getProject());
                resource.touch((IProgressMonitor)localmonitor.split(1));
            }
            catch (CoreException coreException) {}
        }
        if (pjs.size() > 0 && !ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            IProject[] projects = pjs.toArray(new IProject[map.size()]);
            Util.getBuildJob((IProject[])projects, (int)10).schedule();
        }
    }

    public void run(IMarker marker) {
        this.run(new IMarker[]{marker}, null);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        int i = 0;
        while (i < markers.length) {
            try {
                if (markers[i].getType().equals("org.eclipse.pde.api.tools.unused_filters") && !this.fMarker.equals((Object)markers[i])) {
                    mset.add(markers[i]);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        int size = mset.size();
        this.plural = size > 0;
        return mset.toArray(new IMarker[size]);
    }
}

