/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CreateApiFilterOperation
extends Job {
    private IMarker[] fMarkers = null;
    private boolean fAddingComment = false;
    String comment = null;
    boolean cancel = false;

    public CreateApiFilterOperation(IMarker[] markers, boolean addingcomments) {
        super(MarkerMessages.CreateApiFilterOperation_0);
        this.fMarkers = markers;
        this.fAddingComment = addingcomments;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            HashMap map = new HashMap(this.fMarkers.length);
            IResource resource = null;
            IProject project = null;
            HashSet<IProject> projects = new HashSet<IProject>();
            if (this.fAddingComment) {
                CreateApiFilterOperation.getDisplay().syncExec(() -> {
                    InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MarkerMessages.CreateApiFilterOperation_add_filter_comment, MarkerMessages.CreateApiFilterOperation_filter_comment, null, null){

                        protected void createButtonsForButtonBar(Composite parent) {
                            super.createButtonsForButtonBar(parent);
                            this.getButton(0).setText(IDialogConstants.PROCEED_LABEL);
                        }
                    };
                    int okCancel = dialog.open();
                    if (okCancel == 0) {
                        this.comment = dialog.getValue();
                        if (this.comment != null && this.comment.length() < 1) {
                            this.comment = null;
                        }
                    }
                    if (okCancel == 1) {
                        this.cancel = true;
                    }
                });
            }
            if (this.cancel) {
                return Status.CANCEL_STATUS;
            }
            IMarker marker = null;
            IApiProblem problem = null;
            HashSet<IApiProblemFilter> filters = null;
            IApiComponent component = null;
            IMarker[] iMarkerArray = this.fMarkers;
            int n = this.fMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker fMarker = iMarkerArray[n2];
                marker = fMarker;
                resource = marker.getResource();
                project = resource.getProject();
                if (project == null) {
                    return Status.CANCEL_STATUS;
                }
                component = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(project);
                if (component == null) {
                    return Status.CANCEL_STATUS;
                }
                projects.add(project);
                filters = (HashSet)map.get(component);
                if (filters == null) {
                    filters = new HashSet<IApiProblemFilter>();
                    map.put(component, filters);
                }
                String typeNameFromMarker = Util.getTypeNameFromMarker((IMarker)marker);
                problem = ApiProblemFactory.newApiProblem((String)resource.getProjectRelativePath().toPortableString(), (String)typeNameFromMarker, (String[])this.getMessageArgumentsFromMarker(marker), null, null, (int)marker.getAttribute("lineNumber", -1), (int)marker.getAttribute("charStart", -1), (int)marker.getAttribute("charEnd", -1), (int)marker.getAttribute("problemid", 0));
                filters.add(ApiProblemFactory.newProblemFilter((String)component.getSymbolicName(), (IApiProblem)problem, (String)this.comment));
                Util.touchCorrespondingResource((IProject)project, (IResource)resource, (String)typeNameFromMarker);
                ++n2;
            }
            for (Map.Entry entry : map.entrySet()) {
                component = (IApiComponent)entry.getKey();
                IApiFilterStore store = component.getFilterStore();
                filters = (HashSet<IApiProblemFilter>)entry.getValue();
                if (filters == null) continue;
                store.addFilters(filters.toArray(new IApiProblemFilter[filters.size()]));
            }
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Util.getBuildJob((IProject[])projects.toArray(new IProject[projects.size()]), (int)10).schedule();
            }
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            ApiUIPlugin.log(ce);
            return Status.CANCEL_STATUS;
        }
    }

    private String[] getMessageArgumentsFromMarker(IMarker marker) {
        ArrayList args = new ArrayList();
        String arguments = marker.getAttribute("messagearguments", null);
        if (arguments != null) {
            return arguments.split("#");
        }
        return args.toArray(new String[args.size()]);
    }
}

