/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

public class GitResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private static int INTERESTING_CHANGES = 323840;
    private final Repository repository;
    private final Collection<String> filesToUpdate;
    private final Collection<IResource> resourcesToUpdate;
    private final Map<IProject, IPath> deletedProjects;
    private boolean gitIgnoreChanged = false;
    private boolean projectDeleted = false;

    public GitResourceDeltaVisitor(Repository repository) {
        this(repository, Collections.emptyMap());
    }

    public GitResourceDeltaVisitor(Repository repository, Map<IProject, IPath> deletedProjects) {
        this.repository = repository;
        this.filesToUpdate = new HashSet<String>();
        this.resourcesToUpdate = new HashSet<IResource>();
        this.deletedProjects = deletedProjects;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 8) {
            return true;
        }
        if (resource.getType() == 4) {
            if (delta.getKind() == 2) {
                IPath loc = this.deletedProjects.remove(resource);
                if (loc != null) {
                    this.projectDeleted |= !loc.toFile().isDirectory();
                }
                return false;
            }
            if (!ResourceUtil.isSharedWithGit(resource)) {
                return false;
            }
            GitProjectData gitData = GitProjectData.get((IProject)resource);
            if (gitData == null) {
                return false;
            }
            RepositoryMapping mapping = gitData.getRepositoryMapping(resource);
            return mapping != null && (gitData.hasInnerRepositories() || mapping.getRepository() == this.repository);
        }
        Repository repositoryOfResource = null;
        if (resource.isLinked()) {
            IPath location = resource.getLocation();
            if (location == null) {
                return false;
            }
            repositoryOfResource = ResourceUtil.getRepository(location);
            if (this.repository != repositoryOfResource) {
                return false;
            }
        } else {
            repositoryOfResource = ResourceUtil.getRepository(resource);
        }
        if (resource.getType() == 2) {
            GitProjectData gitData = GitProjectData.get(resource.getProject());
            if (gitData == null) {
                return false;
            }
            if (repositoryOfResource == null || !gitData.isProtected(resource) && repositoryOfResource != this.repository) {
                return false;
            }
            if (delta.getKind() == 1) {
                IPath repoRelativePath = ResourceUtil.getRepositoryRelativePath(resource.getLocation(), this.repository);
                if (repoRelativePath == null) {
                    return false;
                }
                if (!repoRelativePath.isEmpty()) {
                    String path = String.valueOf(repoRelativePath.toPortableString()) + "/";
                    if (this.isIgnoredInOldIndex(path)) {
                        return true;
                    }
                    this.filesToUpdate.add(path);
                    this.resourcesToUpdate.add(resource);
                }
            }
            return true;
        }
        if (repositoryOfResource != this.repository) {
            return false;
        }
        if (!GitResourceDeltaVisitor.isInteresting(delta)) {
            return false;
        }
        if (resource.getName().equals(".gitignore")) {
            this.gitIgnoreChanged = true;
            return false;
        }
        IPath repoRelativePath = ResourceUtil.getRepositoryRelativePath(resource.getLocation(), this.repository);
        if (repoRelativePath == null) {
            this.resourcesToUpdate.add(resource);
            return true;
        }
        String path = repoRelativePath.toPortableString();
        if (this.isIgnoredInOldIndex(path)) {
            return false;
        }
        this.filesToUpdate.add(path);
        this.resourcesToUpdate.add(resource);
        return true;
    }

    static boolean isInteresting(IResourceDelta delta) {
        return delta.getKind() != 4 || (delta.getFlags() & INTERESTING_CHANGES) != 0;
    }

    private boolean isIgnoredInOldIndex(String path) {
        if (this.gitIgnoreChanged) {
            return false;
        }
        IndexDiffCacheEntry entry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(this.repository);
        if (entry == null) {
            return false;
        }
        IndexDiffData indexDiff = entry.getIndexDiff();
        if (indexDiff == null) {
            return false;
        }
        String p = path;
        Set<String> ignored = indexDiff.getIgnoredNotInIndex();
        while (p != null) {
            if (ignored.contains(p)) {
                return true;
            }
            p = this.skipLastSegment(p);
        }
        return false;
    }

    private String skipLastSegment(String path) {
        int slashPos = path.lastIndexOf(47);
        return slashPos == -1 ? null : path.substring(0, slashPos);
    }

    public Collection<IFile> getFileResourcesToUpdate() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (IResource resource : this.resourcesToUpdate) {
            if (!(resource instanceof IFile)) continue;
            result.add((IFile)resource);
        }
        return result;
    }

    public Collection<IResource> getResourcesToUpdate() {
        return this.resourcesToUpdate;
    }

    public Collection<String> getFilesToUpdate() {
        return this.filesToUpdate;
    }

    public boolean getGitIgnoreChanged() {
        return this.gitIgnoreChanged;
    }

    public boolean isProjectDeleted() {
        return this.projectDeleted;
    }
}

