/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class ImportRemover {
    private static final String REMOVED = "removed";
    private static final String RETAINED = "retained";
    private static final String PROPERTY_KEY_CLASS_ID = "IR";
    private static final AtomicInteger PROPERTY_KEY_COUNTER = new AtomicInteger();
    private final String propertyKey;
    private final IJavaProject fProject;
    private final CompilationUnit fRoot;
    private Set<String> fAddedImports = new HashSet<String>();
    private Set<StaticImportData> fAddedStaticImports = new HashSet<StaticImportData>();
    private boolean fHasRemovedNodes;
    private List<ImportDeclaration> fInlinedStaticImports = new ArrayList<ImportDeclaration>();

    public ImportRemover(IJavaProject project, CompilationUnit root) {
        this.fProject = project;
        this.fRoot = root;
        this.propertyKey = PROPERTY_KEY_CLASS_ID + PROPERTY_KEY_COUNTER.getAndIncrement();
    }

    private void divideTypeRefs(List<SimpleName> importNames, List<SimpleName> staticNames, List<SimpleName> removedRefs, List<SimpleName> unremovedRefs) {
        final ArrayList<int[]> removedStartsEnds = new ArrayList<int[]>();
        this.fRoot.accept(new ASTVisitor(true){
            int fRemovingStart;
            {
                super($anonymous0);
                this.fRemovingStart = -1;
            }

            public void preVisit(ASTNode node) {
                Object property = node.getProperty(ImportRemover.this.propertyKey);
                if (property == ImportRemover.REMOVED) {
                    if (this.fRemovingStart == -1) {
                        this.fRemovingStart = node.getStartPosition();
                    } else {
                        node.setProperty(ImportRemover.this.propertyKey, null);
                    }
                } else if (property == ImportRemover.RETAINED) {
                    if (this.fRemovingStart != -1) {
                        removedStartsEnds.add(new int[]{this.fRemovingStart, node.getStartPosition()});
                        this.fRemovingStart = -1;
                    } else {
                        node.setProperty(ImportRemover.this.propertyKey, null);
                    }
                }
                super.preVisit(node);
            }

            public void postVisit(ASTNode node) {
                Object property = node.getProperty(ImportRemover.this.propertyKey);
                if (property == ImportRemover.RETAINED) {
                    int end;
                    this.fRemovingStart = end = node.getStartPosition() + node.getLength();
                } else if (property == ImportRemover.REMOVED && this.fRemovingStart != -1) {
                    int end = node.getStartPosition() + node.getLength();
                    removedStartsEnds.add(new int[]{this.fRemovingStart, end});
                    this.fRemovingStart = -1;
                }
                super.postVisit(node);
            }
        });
        for (SimpleName name : importNames) {
            if (this.isInRemoved(name, removedStartsEnds)) {
                removedRefs.add(name);
                continue;
            }
            unremovedRefs.add(name);
        }
        for (SimpleName name : staticNames) {
            if (this.isInRemoved(name, removedStartsEnds)) {
                removedRefs.add(name);
                continue;
            }
            unremovedRefs.add(name);
        }
        for (ImportDeclaration importDecl : this.fInlinedStaticImports) {
            Name name = importDecl.getName();
            if (name instanceof QualifiedName) {
                name = ((QualifiedName)name).getName();
            }
            removedRefs.add((SimpleName)name);
        }
    }

    private boolean isInRemoved(SimpleName ref, List<int[]> removedStartsEnds) {
        int start = ref.getStartPosition();
        int end = start + ref.getLength();
        for (int[] removedStartsEnd : removedStartsEnds) {
            if (start < removedStartsEnd[0] || end > removedStartsEnd[1]) continue;
            return true;
        }
        return false;
    }

    public IBinding[] getImportsToRemove() {
        ArrayList<SimpleName> importNames = new ArrayList<SimpleName>();
        ArrayList<SimpleName> staticNames = new ArrayList<SimpleName>();
        ImportReferencesCollector.collect((ASTNode)this.fRoot, this.fProject, null, importNames, staticNames);
        ArrayList<SimpleName> removedRefs = new ArrayList<SimpleName>();
        ArrayList<SimpleName> unremovedRefs = new ArrayList<SimpleName>();
        this.divideTypeRefs(importNames, staticNames, removedRefs, unremovedRefs);
        if (removedRefs.isEmpty()) {
            return new IBinding[0];
        }
        HashMap<String, IBinding> potentialRemoves = this.getPotentialRemoves(removedRefs);
        for (SimpleName name : unremovedRefs) {
            potentialRemoves.remove(name.getIdentifier());
        }
        Collection<IBinding> importsToRemove = potentialRemoves.values();
        return importsToRemove.toArray(new IBinding[importsToRemove.size()]);
    }

    private HashMap<String, IBinding> getPotentialRemoves(List<SimpleName> removedRefs) {
        HashMap<String, IBinding> potentialRemoves = new HashMap<String, IBinding>();
        for (SimpleName name : removedRefs) {
            IBinding binding;
            if (this.fAddedImports.contains(name.getIdentifier()) || this.hasAddedStaticImport(name) || (binding = name.resolveBinding()) == null) continue;
            potentialRemoves.put(name.getIdentifier(), binding);
        }
        return potentialRemoves;
    }

    private boolean hasAddedStaticImport(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            return this.hasAddedStaticImport(variable.getDeclaringClass().getQualifiedName(), variable.getName(), true);
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            return this.hasAddedStaticImport(method.getDeclaringClass().getQualifiedName(), method.getName(), false);
        }
        return false;
    }

    private boolean hasAddedStaticImport(String qualifier, String member, boolean field) {
        StaticImportData data2 = null;
        for (StaticImportData data2 : this.fAddedStaticImports) {
            if (!data2.fQualifier.equals(qualifier) || !data2.fMember.equals(member) || data2.fField != field) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemovedNodes() {
        return this.fHasRemovedNodes || !this.fInlinedStaticImports.isEmpty();
    }

    public void registerAddedImport(String typeName) {
        int dot = typeName.lastIndexOf(46);
        if (dot == -1) {
            this.fAddedImports.add(typeName);
        } else {
            this.fAddedImports.add(typeName.substring(dot + 1));
        }
    }

    public void registerAddedImports(Type newTypeNode) {
        newTypeNode.accept(new ASTVisitor(true){

            private void addName(SimpleName name) {
                ImportRemover.this.fAddedImports.add(name.getIdentifier());
            }

            public boolean visit(NameQualifiedType node) {
                this.addName(node.getName());
                return false;
            }

            public boolean visit(QualifiedName node) {
                this.addName(node.getName());
                return false;
            }

            public boolean visit(QualifiedType node) {
                this.addName(node.getName());
                return false;
            }

            public boolean visit(SimpleName node) {
                this.addName(node);
                return false;
            }
        });
    }

    public void registerAddedStaticImport(String qualifier, String member, boolean field) {
        this.fAddedStaticImports.add(new StaticImportData(qualifier, member, field));
    }

    public void registerAddedStaticImport(IBinding binding) {
        if (binding instanceof IVariableBinding) {
            ITypeBinding declaringType = ((IVariableBinding)binding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(declaringType), binding.getName(), true));
        } else if (binding instanceof IMethodBinding) {
            ITypeBinding declaringType = ((IMethodBinding)binding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(declaringType), binding.getName(), false));
        } else {
            throw new IllegalArgumentException(binding.toString());
        }
    }

    public void registerRemovedNode(ASTNode removed) {
        this.fHasRemovedNodes = true;
        removed.setProperty(this.propertyKey, (Object)REMOVED);
    }

    public void registerRetainedNode(ASTNode retained) {
        retained.setProperty(this.propertyKey, (Object)RETAINED);
    }

    public void applyRemoves(ImportRewrite importRewrite) {
        IBinding[] iBindingArray = this.getImportsToRemove();
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding binding;
            IBinding b = iBindingArray[n2];
            if (b instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)b;
                importRewrite.removeImport(typeBinding.getTypeDeclaration().getQualifiedName());
            } else if (b instanceof IMethodBinding) {
                binding = (IMethodBinding)b;
                importRewrite.removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + '.' + binding.getName());
            } else if (b instanceof IVariableBinding) {
                binding = (IVariableBinding)b;
                importRewrite.removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + '.' + binding.getName());
            }
            ++n2;
        }
    }

    public void registerInlinedStaticImport(ImportDeclaration importDecl) {
        this.fInlinedStaticImports.add(importDecl);
    }

    private static class StaticImportData {
        private boolean fField;
        private String fMember;
        private String fQualifier;

        private StaticImportData(String qualifier, String member, boolean field) {
            this.fQualifier = qualifier;
            this.fMember = member;
            this.fField = field;
        }
    }
}

