/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.AbstractDeleteContextReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.UndoDeleteContextReferenceChange;

public class DeleteContextReferenceChange
extends AbstractDeleteContextReferenceChange {
    public DeleteContextReferenceChange(IQ7Element element, IContext context, String id) {
        super(element, context, id);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            IQ7NamedElement e = (IQ7NamedElement)this.getElement();
            IQ7NamedElement copy = null;
            boolean isWorkingCopy = e.isWorkingCopy();
            try {
                copy = isWorkingCopy ? e : e.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                List<String> references = this.getContextsReferences(copy);
                int index = references.indexOf(this.getContextId());
                if (index != -1) {
                    references.remove(index);
                    if (copy instanceof ITestCase) {
                        ((ITestCase)copy).setContexts(references.toArray(new String[references.size()]));
                    } else if (copy instanceof IQ7ProjectMetadata) {
                        NamedElement namedElement = copy.getNamedElement();
                        if (namedElement instanceof ProjectMetadata) {
                            ProjectMetadata meta = (ProjectMetadata)namedElement;
                            meta.getContexts().clear();
                            meta.getContexts().addAll(references);
                        }
                    } else {
                        NamedElement namedElement = copy.getNamedElement();
                        if (namedElement instanceof GroupContext) {
                            GroupContext ctx = (GroupContext)namedElement;
                            ctx.getContextReferences().clear();
                            ctx.getContextReferences().addAll(references);
                        }
                    }
                    copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                    UndoDeleteContextReferenceChange undoDeleteContextReferenceChange = new UndoDeleteContextReferenceChange(this.getElement(), (IFile)this.getElement().getResource(), this.getContext(), this.getContextId(), index);
                    return undoDeleteContextReferenceChange;
                }
            }
            finally {
                if (!isWorkingCopy) {
                    copy.discardWorkingCopy();
                }
            }
            {
            }
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return Messages.bind((String)Messages.DeleteContextReferenceChange_Name, (Object)this.getContext().getName(), (Object)this.getElement().getName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.DeleteContextReferenceChange_InvalidRefMsg);
        }
        return new RefactoringStatus();
    }

    @Override
    protected boolean isValid() throws ModelException {
        if (!super.isValid()) {
            return false;
        }
        IQ7NamedElement element = (IQ7NamedElement)this.getElement();
        IQ7NamedElement copy = null;
        try {
            copy = element.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            List<String> references = this.getContextsReferences(copy);
            boolean bl = references.contains(this.getContextId());
            return bl;
        }
        finally {
            copy.discardWorkingCopy();
        }
    }
}

