/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceResourceDialog
extends ElementTreeSelectionDialog
implements ISelectionStatusValidator {
    protected boolean showNewFolderControl = false;
    protected boolean showFileControl = false;
    protected boolean showFiles = true;
    protected Button newFolderButton;
    protected Text fileText;
    protected String fileTextContent = "";
    protected IContainer selectedContainer;

    public static IContainer[] openFolderSelection(Shell parent, String title, String message, boolean allowMultipleSelection, Object[] initialSelection, List<ViewerFilter> viewerFilters) {
        WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(allowMultipleSelection);
        dialog.setTitle(title != null ? title : CommonUIPlugin.INSTANCE.getString("_UI_FolderSelection_title"));
        dialog.setMessage(message);
        dialog.setShowNewFolderControl(true);
        dialog.addFilter(dialog.createDefaultViewerFilter(false));
        if (viewerFilters != null) {
            for (ViewerFilter viewerFilter : viewerFilters) {
                dialog.addFilter(viewerFilter);
            }
        }
        if (initialSelection != null) {
            dialog.setInitialSelections(initialSelection);
        }
        dialog.loadContents();
        return dialog.open() == 0 ? dialog.getSelectedContainers() : new IContainer[]{};
    }

    public static IFile[] openFileSelection(Shell parent, String title, String message, boolean allowMultipleSelection, Object[] initialSelection, List<ViewerFilter> viewerFilters) {
        WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(allowMultipleSelection);
        dialog.setTitle(title != null ? title : CommonUIPlugin.INSTANCE.getString("_UI_FileSelection_title"));
        dialog.setMessage(message);
        dialog.addFilter(dialog.createDefaultViewerFilter(true));
        if (viewerFilters != null) {
            for (ViewerFilter viewerFilter : viewerFilters) {
                dialog.addFilter(viewerFilter);
            }
        }
        if (initialSelection != null) {
            dialog.setInitialSelections(initialSelection);
        }
        dialog.loadContents();
        return dialog.open() == 0 ? dialog.getSelectedFiles() : new IFile[]{};
    }

    public static IFile openNewFile(Shell parent, String title, String message, IPath suggestedPath, List<ViewerFilter> viewerFilters) {
        WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(false);
        dialog.setTitle(title != null ? title : CommonUIPlugin.INSTANCE.getString("_UI_NewFile_title"));
        dialog.setMessage(message);
        dialog.setShowNewFolderControl(true);
        dialog.setShowFileControl(true);
        dialog.addFilter(dialog.createDefaultViewerFilter(false));
        if (viewerFilters != null) {
            for (ViewerFilter viewerFilter : viewerFilters) {
                dialog.addFilter(viewerFilter);
            }
        }
        if (suggestedPath != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember(suggestedPath);
            if (resource != null && resource.isAccessible()) {
                if (resource instanceof IContainer) {
                    dialog.setInitialSelection(resource);
                } else {
                    dialog.setInitialSelection(resource.getParent());
                    dialog.setFileText(resource.getName());
                }
            } else {
                if (suggestedPath.segmentCount() > 1) {
                    if (resource == null) {
                        resource = root.getFile(suggestedPath);
                    }
                    if (resource.getProject().isAccessible()) {
                        IContainer container = resource.getParent();
                        while (!container.isAccessible() && container != resource.getProject()) {
                            container = container.getParent();
                        }
                        dialog.setInitialSelection(container);
                        suggestedPath = suggestedPath.removeFirstSegments(container.getFullPath().segmentCount());
                        dialog.setFileText(suggestedPath.toString());
                        suggestedPath = null;
                    }
                }
                if (suggestedPath != null) {
                    String fileText = suggestedPath.isAbsolute() ? suggestedPath.removeFirstSegments(1).toString() : suggestedPath.toString();
                    dialog.setFileText(fileText);
                }
            }
        }
        dialog.loadContents();
        return dialog.open() == 0 ? dialog.getFile() : null;
    }

    public WorkspaceResourceDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        this.setValidator(this);
    }

    public void loadContents() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.setInput(root);
    }

    public ViewerFilter createDefaultViewerFilter(boolean showFiles) {
        this.showFiles = showFiles;
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IResource workspaceResource = (IResource)element;
                    return workspaceResource.isAccessible() && (WorkspaceResourceDialog.this.showFiles || workspaceResource.getType() != 1);
                }
                return false;
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.isShowNewFolderControl()) {
            this.createNewFolderControl(composite);
        }
        if (this.isShowFileControl()) {
            this.createFileControl(composite);
        }
        WorkspaceResourceDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createNewFolderControl(Composite parent) {
        this.newFolderButton = new Button(parent, 8);
        this.newFolderButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_NewFolder_label"));
        this.newFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkspaceResourceDialog.this.newFolderButtonPressed();
            }
        });
        this.newFolderButton.setFont(parent.getFont());
        this.updateNewFolderButtonState();
    }

    protected void updateNewFolderButtonState() {
        Object first;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.selectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.selectedContainer = (IContainer)first;
        }
        this.newFolderButton.setEnabled(this.selectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), this.selectedContainer);
        if (dialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.selectedContainer);
            Object createdFolder = dialog.getResult()[0];
            treeViewer.reveal(createdFolder);
            treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
        }
    }

    protected void createFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        composite.setLayout((Layout)layout);
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(CommonUIPlugin.INSTANCE.getString("_UI_FileName_label"));
        this.fileText = new Text(composite, 2048);
        this.fileText.setLayoutData((Object)new GridData(768));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkspaceResourceDialog.this.fileTextModified(WorkspaceResourceDialog.this.fileText.getText());
            }
        });
        if (this.fileTextContent != null) {
            this.fileText.setText(this.fileTextContent);
        }
    }

    protected void fileTextModified(String text) {
        this.fileTextContent = text;
        this.updateOKStatus();
    }

    public IStatus validate(Object[] selectedElements) {
        if (this.isShowNewFolderControl()) {
            this.updateNewFolderButtonState();
        }
        boolean enableOK = false;
        int i = 0;
        while (i < selectedElements.length) {
            if (selectedElements[i] instanceof IContainer) {
                enableOK = !this.showFiles || this.isShowFileControl() && this.fileText.getText().trim().length() > 0;
            } else if (selectedElements[i] instanceof IFile) {
                if (this.isShowFileControl()) {
                    this.fileText.setText(((IFile)selectedElements[i]).getName());
                }
                enableOK = true;
            }
            if (enableOK) break;
            ++i;
        }
        return enableOK ? new Status(0, "org.eclipse.emf.common.ui", 0, "", null) : new Status(4, "org.eclipse.emf.common.ui", 0, "", null);
    }

    public IContainer[] getSelectedContainers() {
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        Object[] result = this.getResult();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof IContainer) {
                containers.add((IContainer)result[i]);
            }
            ++i;
        }
        return containers.toArray(new IContainer[containers.size()]);
    }

    public IFile[] getSelectedFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Object[] result = this.getResult();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof IFile) {
                files.add((IFile)result[i]);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public IFile getFile() {
        Object[] result;
        String file = this.getFileText();
        if (file.length() != 0 && (result = this.getResult()).length == 1) {
            if (result[0] instanceof IFile) {
                return (IFile)result[0];
            }
            if (result[0] instanceof IContainer) {
                IContainer container = (IContainer)result[0];
                return container.getFile((IPath)new Path(file));
            }
        }
        return null;
    }

    public void setFileText(String text) {
        if (text == null) {
            text = "";
        }
        if (this.fileText != null && !this.fileText.isDisposed()) {
            this.fileText.setText(text);
        } else {
            this.fileTextContent = text;
        }
    }

    public String getFileText() {
        return this.fileText != null && !this.fileText.isDisposed() ? this.fileText.getText() : this.fileTextContent;
    }

    public boolean isShowNewFolderControl() {
        return this.showNewFolderControl;
    }

    public void setShowNewFolderControl(boolean showNewFolderControl) {
        this.showNewFolderControl = showNewFolderControl;
    }

    public boolean isShowFileControl() {
        return this.showFileControl;
    }

    public void setShowFileControl(boolean showFileControl) {
        this.showFileControl = showFileControl;
    }
}

