/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ReplaceRefactoring
extends Refactoring {
    private final FileSearchResult fResult;
    private final Object[] fSelection;
    private final HashMap<IFile, Set<FileMatch>> fMatches;
    private final Map<URI, IFile> fAlreadyCollected;
    private Map<URI, ArrayList<FileMatch>> fIgnoredMatches;
    private String fReplaceString;
    private Change fChange;

    public ReplaceRefactoring(FileSearchResult result, Object[] selection) {
        Assert.isNotNull((Object)result);
        this.fResult = result;
        this.fSelection = selection;
        this.fMatches = new HashMap();
        this.fAlreadyCollected = new HashMap<URI, IFile>(selection != null ? selection.length : result.getElements().length);
        this.fReplaceString = null;
    }

    public String getName() {
        return SearchMessages.ReplaceRefactoring_refactoring_name;
    }

    public void setReplaceString(String string) {
        this.fReplaceString = string;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String searchString = this.getQuery().getSearchString();
        if (searchString.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_illegal_search_string);
        }
        this.fMatches.clear();
        if (this.fSelection != null) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm);
            progress.setWorkRemaining(100000);
            Object[] objectArray = this.fSelection;
            int n = this.fSelection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.collectMatches(element, progress);
                ++n2;
            }
        } else {
            Object[] elements = this.fResult.getElements();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n3 = 0;
            while (n3 < n) {
                Object element = objectArray[n3];
                this.collectMatches(element, progress.split(1));
                ++n3;
            }
        }
        if (!this.hasMatches()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_matches);
        }
        return new RefactoringStatus();
    }

    private void collectMatches(Object object, SubMonitor progress) throws CoreException {
        Match[] matches;
        progress.checkCanceled();
        if (object instanceof LineElement) {
            FileMatch[] matches2;
            LineElement lineElement = (LineElement)object;
            FileMatch[] fileMatchArray = matches2 = lineElement.getMatches(this.fResult);
            int n = matches2.length;
            int n2 = 0;
            while (n2 < n) {
                FileMatch fileMatch = fileMatchArray[n2];
                if (this.isMatchToBeIncluded(fileMatch)) {
                    this.getBucket(fileMatch.getFile()).add(fileMatch);
                }
                ++n2;
            }
        } else if (object instanceof IContainer) {
            IResource[] members;
            IContainer container = (IContainer)object;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n3 = 0;
            while (n3 < n) {
                IResource member = iResourceArray[n3];
                this.collectMatches(member, progress);
                ++n3;
            }
        } else if (object instanceof IFile && (matches = this.fResult.getMatches(object)).length > 0) {
            Set<FileMatch> bucket = null;
            Match[] matchArray = matches;
            int n = matches.length;
            int n4 = 0;
            while (n4 < n) {
                Match match = matchArray[n4];
                FileMatch fileMatch = (FileMatch)match;
                if (this.isMatchToBeIncluded(fileMatch)) {
                    if (bucket == null) {
                        bucket = this.getBucket((IFile)object);
                    }
                    bucket.add(fileMatch);
                }
                ++n4;
            }
        }
        progress.worked(1);
    }

    public int getNumberOfFiles() {
        return this.fMatches.size();
    }

    public int getNumberOfMatches() {
        int count = 0;
        for (Set<FileMatch> bucket : this.fMatches.values()) {
            count += bucket.size();
        }
        return count;
    }

    public boolean hasMatches() {
        return !this.fMatches.isEmpty();
    }

    private boolean isMatchToBeIncluded(FileMatch match) {
        IFile file = match.getFile();
        URI uri = file.getLocationURI();
        if (uri == null) {
            return true;
        }
        if (file.equals((Object)this.fAlreadyCollected.get(uri))) {
            return true;
        }
        for (URI uri2 : this.fAlreadyCollected.keySet()) {
            ArrayList<FileMatch> matches;
            if (!URIUtil.equals((URI)uri2, (URI)uri)) continue;
            if (this.fIgnoredMatches == null) {
                this.fIgnoredMatches = new HashMap<URI, ArrayList<FileMatch>>();
            }
            if ((matches = this.fIgnoredMatches.get(uri)) == null) {
                matches = new ArrayList();
                this.fIgnoredMatches.put(uri, matches);
            }
            matches.add(match);
            return false;
        }
        this.fAlreadyCollected.put(uri, file);
        return true;
    }

    private Set<FileMatch> getBucket(IFile file) {
        Set<FileMatch> set = this.fMatches.get(file);
        if (set == null) {
            set = new HashSet<FileMatch>();
            this.fMatches.put(file, set);
        }
        return set;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fReplaceString == null) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_replace_string);
        }
        Pattern pattern = null;
        FileSearchQuery query = this.getQuery();
        if (query.isRegexSearch()) {
            pattern = this.createSearchPattern(query);
        }
        RefactoringStatus resultingStatus = new RefactoringStatus();
        Set<IFile> allFilesSet = this.fMatches.keySet();
        IFile[] allFiles = allFilesSet.toArray(new IFile[allFilesSet.size()]);
        Arrays.sort(allFiles, new Comparator<IFile>(){
            private Collator fCollator = Collator.getInstance();

            @Override
            public int compare(IFile o1, IFile o2) {
                String p1 = o1.getFullPath().toString();
                String p2 = o2.getFullPath().toString();
                return this.fCollator.compare(p1, p2);
            }
        });
        int workSize = allFiles.length;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)(workSize * 2));
        this.checkFilesToBeChanged(allFiles, resultingStatus, progress.split(workSize));
        if (resultingStatus.hasFatalError()) {
            return resultingStatus;
        }
        progress.setWorkRemaining(workSize);
        CompositeChange compositeChange = new CompositeChange(SearchMessages.ReplaceRefactoring_composite_change_name);
        compositeChange.markAsSynthetic();
        ArrayList<MatchGroup> matchGroups = new ArrayList<MatchGroup>();
        boolean hasChanges = false;
        try {
            IFile[] iFileArray = allFiles;
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                progress.checkCanceled();
                Set<FileMatch> bucket = this.fMatches.get(file);
                if (!bucket.isEmpty()) {
                    try {
                        TextChange change = this.createFileChange(file, pattern, bucket, resultingStatus, matchGroups, progress);
                        if (change != null) {
                            compositeChange.add((Change)change);
                            hasChanges = true;
                        }
                    }
                    catch (CoreException e) {
                        String message = Messages.format(SearchMessages.ReplaceRefactoring_error_access_file, new Object[]{file.getName(), e.getLocalizedMessage()});
                        return RefactoringStatus.createFatalErrorStatus((String)message);
                    }
                }
                progress.worked(1);
                ++n2;
            }
        }
        catch (PatternSyntaxException e) {
            String message = Messages.format(SearchMessages.ReplaceRefactoring_error_replacement_expression, e.getLocalizedMessage());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (!hasChanges && resultingStatus.isOK()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_changes);
        }
        compositeChange.add((Change)new SearchResultUpdateChange(this.fResult, matchGroups.toArray(new MatchGroup[matchGroups.size()]), this.fIgnoredMatches));
        this.fChange = compositeChange;
        return resultingStatus;
    }

    private void checkFilesToBeChanged(IFile[] filesToBeChanged, RefactoringStatus resultingStatus, SubMonitor pm) throws CoreException {
        ArrayList<IFile> readOnly = new ArrayList<IFile>();
        IFile[] iFileArray = filesToBeChanged;
        int n = filesToBeChanged.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            pm.checkCanceled();
            if (file.isReadOnly()) {
                readOnly.add(file);
            }
            ++n2;
        }
        IFile[] readOnlyFiles = readOnly.toArray(new IFile[readOnly.size()]);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles, this.getValidationContext());
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        resultingStatus.merge(RefactoringStatus.create((IStatus)status));
        if (resultingStatus.hasFatalError()) {
            return;
        }
        resultingStatus.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeChanged, null));
    }

    private TextChange createFileChange(IFile file, Pattern pattern, Set<FileMatch> matches, RefactoringStatus resultingStatus, Collection<MatchGroup> matchGroups, SubMonitor pm) throws PatternSyntaxException, CoreException {
        PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
        TextFileChange change = new TextFileChange(Messages.format(SearchMessages.ReplaceRefactoring_group_label_change_for_file, file.getName()), file);
        change.setEdit((TextEdit)new MultiTextEdit());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(file.getFullPath(), LocationKind.IFILE, null);
        try {
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer == null) {
                resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_accessing_file_buffer, file.getName()));
                return null;
            }
            IDocument document = textFileBuffer.getDocument();
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            for (FileMatch match : matches) {
                String originalText;
                pm.checkCanceled();
                int offset = match.getOffset();
                int length = match.getLength();
                Position currentPosition = tracker.getCurrentPosition(match);
                if (currentPosition != null) {
                    offset = currentPosition.offset;
                    if (length != currentPosition.length) {
                        resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_match_content_changed, file.getName()));
                        continue;
                    }
                }
                if ((originalText = ReplaceRefactoring.getOriginalText(document, offset, length)) == null) {
                    resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_match_content_changed, file.getName()));
                    continue;
                }
                String replacementString = this.computeReplacementString(pattern, originalText, this.fReplaceString, lineDelimiter);
                if (replacementString == null) {
                    resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_match_content_changed, file.getName()));
                    continue;
                }
                ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, replacementString);
                change.addEdit((TextEdit)replaceEdit);
                TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)change, new TextEditGroup(SearchMessages.ReplaceRefactoring_group_label_match_replace, (TextEdit)replaceEdit));
                change.addTextEditChangeGroup(textEditChangeGroup);
                matchGroups.add(new MatchGroup(textEditChangeGroup, match));
            }
        }
        finally {
            manager.disconnect(file.getFullPath(), LocationKind.IFILE, null);
        }
        return change;
    }

    private static String getOriginalText(IDocument doc, int offset, int length) {
        try {
            return doc.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Pattern createSearchPattern(FileSearchQuery query) {
        return PatternConstructor.createPattern(query.getSearchString(), true, true, query.isCaseSensitive(), false);
    }

    private String computeReplacementString(Pattern pattern, String originalText, String replacementText, String lineDelimiter) throws PatternSyntaxException {
        if (pattern != null) {
            StringBuilder sb;
            Matcher matcher;
            try {
                replacementText = PatternConstructor.interpretReplaceEscapes(replacementText, originalText, lineDelimiter);
                matcher = pattern.matcher(originalText);
                sb = new StringBuilder();
                matcher.reset();
                if (!matcher.find()) {
                    return null;
                }
                matcher.appendReplacement(sb, replacementText);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getLocalizedMessage(), replacementText, -1);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return replacementText;
    }

    public FileSearchQuery getQuery() {
        return (FileSearchQuery)this.fResult.getQuery();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fChange;
    }

    private static class MatchGroup {
        public TextEditChangeGroup group;
        public FileMatch match;

        public MatchGroup(TextEditChangeGroup group, FileMatch match) {
            this.group = group;
            this.match = match;
        }
    }

    public static class SearchResultUpdateChange
    extends Change {
        private MatchGroup[] fMatchGroups;
        private Match[] fMatches;
        private Map<URI, ArrayList<FileMatch>> fIgnoredMatches;
        private final FileSearchResult fResult;
        private final boolean fIsRemove;

        public SearchResultUpdateChange(FileSearchResult result, MatchGroup[] matchGroups, Map<URI, ArrayList<FileMatch>> ignoredMatches) {
            this(result, null, ignoredMatches, true);
            this.fMatchGroups = matchGroups;
        }

        private SearchResultUpdateChange(FileSearchResult result, Match[] matches, Map<URI, ArrayList<FileMatch>> ignoredMatches, boolean isRemove) {
            this.fResult = result;
            this.fMatches = matches;
            this.fIgnoredMatches = ignoredMatches;
            this.fIsRemove = isRemove;
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return SearchMessages.ReplaceRefactoring_result_update_name;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        private Match[] getMatches() {
            if (this.fMatches == null) {
                ArrayList<FileMatch> matches = new ArrayList<FileMatch>();
                MatchGroup[] matchGroupArray = this.fMatchGroups;
                int n = this.fMatchGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    MatchGroup curr = matchGroupArray[n2];
                    if (curr.group.isEnabled()) {
                        ArrayList<FileMatch> ignoredMatches;
                        IFile file;
                        URI uri;
                        FileMatch match = curr.match;
                        matches.add(match);
                        if (this.fIgnoredMatches != null && (uri = (file = match.getFile()).getLocationURI()) != null && (ignoredMatches = this.fIgnoredMatches.get(uri)) != null) {
                            matches.addAll(ignoredMatches);
                        }
                    }
                    ++n2;
                }
                this.fMatches = matches.toArray(new Match[matches.size()]);
                this.fMatchGroups = null;
            }
            return this.fMatches;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Match[] matches = this.getMatches();
            if (this.fIsRemove) {
                this.fResult.removeMatches(matches);
            } else {
                this.fResult.addMatches(matches);
            }
            return new SearchResultUpdateChange(this.fResult, matches, this.fIgnoredMatches, !this.fIsRemove);
        }
    }
}

