/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;

public class FirstLambdaLocationLocator
extends ASTVisitor {
    private int fNodeLength = -1;
    private int fNodeOffset = -1;
    private int fLineOffset = -1;
    private int fLineEndPosition = -1;
    private String fLambdaMethodName;
    private boolean fLocationFound = false;

    public FirstLambdaLocationLocator(int lineOffset, int lineEndPosition) {
        this.fLineOffset = lineOffset;
        this.fLineEndPosition = lineEndPosition;
    }

    public String getLambdaMethodName() {
        return this.fLambdaMethodName;
    }

    public int getNodeLength() {
        return this.fNodeLength;
    }

    public int getNodeOffset() {
        return this.fNodeOffset;
    }

    public boolean visit(LambdaExpression node) {
        if (this.fLocationFound) {
            return false;
        }
        if (node.getStartPosition() < this.fLineOffset || node.getStartPosition() > this.fLineEndPosition) {
            return false;
        }
        this.fNodeLength = node.getLength();
        this.fNodeOffset = node.getStartPosition();
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding != null) {
            this.fLambdaMethodName = this.toMethodName(methodBinding);
            this.fLocationFound = true;
        }
        return false;
    }

    private String toMethodName(IMethodBinding methodBinding) {
        String key = methodBinding.getKey();
        return key.substring(key.indexOf(46) + 1, key.indexOf(40));
    }
}

