/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.loc.dashboard.ui.wizards.PersonalDataPack;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.ComposedPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.PageFields;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.core.request.PersonalLicenseData;

public final class IssueLicenseRequestPage
implements Supplier<IWizardPage> {
    private final Supplier<Optional<LicensePlan>> plan;
    private final Supplier<Optional<User>> user;
    private final Supplier<Optional<ProductVersion>> product;
    private final Supplier<Optional<List<LocalDate>>> period;
    private final ComposedPage page;

    IssueLicenseRequestPage(IEclipseContext context, PersonalDataPack initial) {
        this.page = new ComposedPage(IssueLicenseRequestPage.class.getSimpleName(), IssueLicensePageMessages.IssueLicenseRequestPage_page_description, context);
        PageFields block = this.page.withBlock();
        this.plan = block.withLicensePlan(initial.plan());
        this.user = block.withUser(initial.user());
        this.product = block.withProductVersion(initial.product());
        this.period = block.withPeriod();
    }

    @Override
    public IWizardPage get() {
        return this.page.get();
    }

    public PersonalLicenseRequest request() {
        return new PersonalLicenseData(() -> this.user.get().get(), () -> this.plan.get().get(), () -> this.product.get().get(), () -> this.from(), () -> this.until());
    }

    private LocalDate from() {
        return this.period.get().get().get(0);
    }

    private LocalDate until() {
        return this.period.get().get().get(1);
    }
}

