/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.restrictions;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.base.restrictions.RestrictionMustPauseExecution;

public final class CertificateIsSufficient
implements Predicate<Optional<ExaminationCertificate>> {
    private final String feature;

    public CertificateIsSufficient(String feature) {
        this.feature = Objects.requireNonNull(feature);
    }

    @Override
    public boolean test(Optional<ExaminationCertificate> certificate) {
        if (!certificate.isPresent()) {
            return false;
        }
        if (this.anyRestrictionForFeature(certificate.get())) {
            return false;
        }
        return !this.anyAgreementForFeatureIsNotAccepted(certificate.get());
    }

    private boolean anyRestrictionForFeature(ExaminationCertificate certificate) {
        return certificate.restrictions().stream().filter(this::notBearable).anyMatch(this::relatesToFeature);
    }

    private boolean anyAgreementForFeatureIsNotAccepted(ExaminationCertificate certificate) {
        return certificate.agreements().stream().filter(this::notAccepted).anyMatch(this::relatesToFeature);
    }

    private boolean notBearable(Restriction restriction) {
        return new RestrictionMustPauseExecution().test(restriction);
    }

    private boolean relatesToFeature(Restriction restriction) {
        return this.relatesToFeature(restriction.unsatisfiedRequirement());
    }

    private boolean relatesToFeature(AgreementToAccept agreement) {
        return this.relatesToFeature(agreement.origin());
    }

    private boolean relatesToFeature(Requirement reqirement) {
        return this.feature.equals(reqirement.feature().identifier());
    }

    private boolean notAccepted(AgreementToAccept agreement) {
        return !agreement.acceptance().accepted();
    }
}

