/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;

final class ConditionSerializer
extends StdSerializer<Condition> {
    private static final long serialVersionUID = -8694881423638827104L;

    ConditionSerializer(Class<Condition> type) {
        super(type);
    }

    public void serialize(Condition condition, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("identifier", condition.identifier());
        gen.writeStringField("feature", condition.feature());
        gen.writeStringField("version", condition.versionMatch().version());
        gen.writeStringField("rule", condition.versionMatch().rule().identifier());
        gen.writeObjectField("period-closed-from", (Object)((ValidityPeriodClosed)condition.validityPeriod()).from());
        gen.writeObjectField("period-closed-to", (Object)((ValidityPeriodClosed)condition.validityPeriod()).to());
        gen.writeStringField("type", condition.evaluationInstructions().type().identifier());
        gen.writeStringField("expression", condition.evaluationInstructions().expression());
        gen.writeEndObject();
    }
}

