/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface.license;

import java.text.SimpleDateFormat;
import java.util.Optional;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportLicenseReportWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.PageObserver;
import org.eclipse.passage.loc.report.internal.ui.jface.license.DataForExport;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

final class PreviewPage
extends WizardPage
implements PageObserver {
    private final LicenseStorage storage;
    private List plans;
    private Label period;
    private Label path;
    private Button explained;
    private final DataForExport data;
    private final SimpleDateFormat format = new SimpleDateFormat("dd.MM.YYYY");

    protected PreviewPage(LicenseStorage storage, DataForExport data) {
        super("preview");
        this.storage = storage;
        this.data = data;
        this.setTitle(ExportLicenseReportWizardMessages.PreviewPage_title);
        this.setMessage(ExportLicenseReportWizardMessages.PreviewPage_description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.plans = new List(content, 2056);
        this.plans.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.path = new Label(content, 0);
        this.path.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
        this.period = new Label(content, 0);
        this.period.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
        new Label(content, 0).setText(ExportLicenseReportWizardMessages.PreviewPage_explained);
        this.explained = new Button(content, 32);
        this.explained.setEnabled(false);
        this.setControl((Control)content);
    }

    @Override
    public void update() {
        this.updateTargetPath();
        this.updatePlans();
        this.updatePeriod();
        this.updateExplained();
        this.getWizard().getContainer().updateButtons();
    }

    private void updateTargetPath() {
        this.path.setText(NLS.bind((String)ExportLicenseReportWizardMessages.PreviewPage_path, (Object)this.data.target().toString()));
    }

    private void updatePlans() {
        this.plans.removeAll();
        this.data.plans().stream().map(arg_0 -> ((LicenseStorage)this.storage).plan(arg_0)).filter(Optional::isPresent).map(Optional::get).map(this::planInfo).forEach(arg_0 -> ((List)this.plans).add(arg_0));
    }

    private void updatePeriod() {
        this.period.setText(NLS.bind((String)ExportLicenseReportWizardMessages.PreviewPage_period, (Object)this.format.format(this.data.from()), (Object)this.format.format(this.data.to())));
    }

    private String planInfo(LicensePlan plan) {
        return NLS.bind((String)"{0} ({1})", (Object)plan.getName(), (Object)plan.getIdentifier());
    }

    private void updateExplained() {
        this.explained.setSelection(this.data.explain());
    }
}

