/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc.remote.impl.acquire;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionService;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.base.io.LicensingFolder;
import org.eclipse.passage.lic.base.io.UserHomePath;
import org.eclipse.passage.lic.hc.remote.Client;
import org.eclipse.passage.lic.hc.remote.Connection;
import org.eclipse.passage.lic.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.hc.remote.impl.HttpClient;
import org.eclipse.passage.lic.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.hc.remote.impl.acquire.RemoteAcquire;
import org.eclipse.passage.lic.hc.remote.impl.acquire.RemoteRelease;

public final class RemoteAcquisitionService<C extends Connection>
implements LicenseAcquisitionService {
    private final Equipment equipment;
    private final ConditionMiningTarget target = new ConditionMiningTarget.Remote();
    private final Supplier<Client<C, GrantAcquisition>> acquire;
    private final Supplier<Client<C, Boolean>> release;
    private final Supplier<Path> source;

    public RemoteAcquisitionService(Equipment equipment, Supplier<Client<C, GrantAcquisition>> acquire, Supplier<Client<C, Boolean>> release, Supplier<Path> source) {
        this.equipment = equipment;
        this.acquire = acquire;
        this.release = release;
        this.source = source;
    }

    public RemoteAcquisitionService(Equipment equipment) {
        this(equipment, HttpClient::new, HttpClient::new, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    public ConditionMiningTarget id() {
        return this.target;
    }

    public ServiceInvocationResult<GrantAcquisition> acquire(LicensedProduct product, String feature) {
        return new RemoteAcquire<C>(this.equipment, this.acquire, this.source).request(new RemoteServiceData.OfFeature(product, feature));
    }

    public ServiceInvocationResult<Boolean> release(LicensedProduct product, GrantAcquisition acquisition) {
        return new RemoteRelease<C>(this.equipment, this.release, this.source).request(new RemoteServiceData.WithPayload<GrantAcquisition>(product, acquisition));
    }
}

