/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.evaluation;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.api.conditions.evaluation.Emission;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluatorsRegistry;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionPasringRegistry;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionTokenAssessorsRegistry;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;
import org.eclipse.passage.lic.base.conditions.evaluation.Authentication;
import org.eclipse.passage.lic.base.conditions.evaluation.BasePermission;
import org.eclipse.passage.lic.base.conditions.evaluation.SumOfEmissions;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.LicenseDoesNotMatch;
import org.eclipse.passage.lic.base.diagnostic.code.LicenseExpired;
import org.eclipse.passage.lic.base.diagnostic.code.LicenseInvalid;
import org.eclipse.passage.lic.base.diagnostic.code.LicenseNotStarted;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.base.i18n.ConditionsEvaluationMessages;

public final class BasePermissionEmittingService
implements PermissionEmittingService {
    private final StringServiceId id = new StringServiceId("default-emitter");
    private final Authentication authentication;

    public BasePermissionEmittingService(ExpressionPasringRegistry parsers, ExpressionTokenAssessorsRegistry assessors, ExpressionEvaluatorsRegistry evaluators) {
        this.authentication = new Authentication(parsers, assessors, evaluators);
    }

    public StringServiceId id() {
        return this.id;
    }

    public ServiceInvocationResult<Collection<Emission>> emit(Collection<ConditionPack> conditions, LicensedProduct product) {
        return conditions.stream().map(pack -> this.emitFor((ConditionPack)pack, product)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).orElse(new BaseServiceInvocationResult(new ArrayList()));
    }

    private ServiceInvocationResult<Collection<Emission>> emitFor(ConditionPack pack, LicensedProduct product) {
        return pack.conditions().stream().map(condition -> this.emitFor((Condition)condition, pack, product)).reduce(new BaseServiceInvocationResult.Sum<Emission>(new SumOfEmissions())).map(this::singleton).orElse(new BaseServiceInvocationResult(Collections.emptyList()));
    }

    private ServiceInvocationResult<Collection<Emission>> singleton(ServiceInvocationResult<Emission> origin) {
        return new BaseServiceInvocationResult<Collection<Emission>>(origin.diagnostic(), origin.data().isPresent() ? Collections.singleton((Emission)origin.data().get()) : Collections.emptyList());
    }

    private ServiceInvocationResult<Emission> emitFor(Condition condition, ConditionPack pack, LicensedProduct product) {
        Optional<ServiceInvocationResult<Emission>> auth = this.authenticationDenial(condition, pack);
        if (auth.isPresent()) {
            return auth.get();
        }
        Optional<ServiceInvocationResult<Emission>> time = this.timeDenial(condition, pack);
        if (time.isPresent()) {
            return time.get();
        }
        return this.createFor(condition, pack, product);
    }

    private Optional<ServiceInvocationResult<Emission>> authenticationDenial(Condition condition, ConditionPack pack) {
        try {
            this.authentication.verify(condition.evaluationInstructions());
        }
        catch (ExpressionParsingException e) {
            return this.fail(pack, (TroubleCode)new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.parse_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        catch (LicensingException e) {
            return this.fail(pack, (TroubleCode)new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.assessment_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            return this.fail(pack, (TroubleCode)new LicenseDoesNotMatch(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.evaluation_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        return Optional.empty();
    }

    private Optional<ServiceInvocationResult<Emission>> timeDenial(Condition condition, ConditionPack pack) {
        if (!this.validityPeriodIsSupported(condition)) {
            return this.fail(pack, new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.validity_period_unsupported"), condition.validityPeriod().getClass().getName()));
        }
        ZonedDateTime from = this.from(condition);
        if (ZonedDateTime.now().isBefore(from)) {
            return this.fail(pack, new LicenseNotStarted(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.license_not_started"), from.toString()));
        }
        ZonedDateTime expiration = this.expiration(condition);
        if (ZonedDateTime.now().isAfter(expiration)) {
            return this.fail(pack, new LicenseExpired(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.license_expired"), expiration.toString()));
        }
        return Optional.empty();
    }

    private ServiceInvocationResult<Emission> createFor(Condition condition, ConditionPack pack, LicensedProduct product) {
        try {
            return new BaseServiceInvocationResult<Emission>(new Emission(pack, (Permission)new BasePermission(product, condition, this.from(condition), this.expiration(condition), pack.origin())));
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult<Emission>(new BaseDiagnostic(Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.failed_create_permission"), condition.feature(), condition.identifier()), e))));
        }
    }

    private Optional<ServiceInvocationResult<Emission>> fail(ConditionPack pack, TroubleCode code, String explanation, Exception e) {
        return this.fail(pack, code, explanation, Optional.of(e));
    }

    private Optional<ServiceInvocationResult<Emission>> fail(ConditionPack pack, TroubleCode code, String explanation) {
        return this.fail(pack, code, explanation, Optional.empty());
    }

    private Optional<ServiceInvocationResult<Emission>> fail(ConditionPack pack, TroubleCode code, String explanation, Optional<Exception> e) {
        return Optional.of(new BaseServiceInvocationResult<Emission>((Diagnostic)new BaseDiagnostic(Collections.singletonList(new Trouble(code, explanation, e))), new Emission(pack)));
    }

    private ZonedDateTime from(Condition condition) {
        return ((ValidityPeriodClosed)condition.validityPeriod()).from();
    }

    private ZonedDateTime expiration(Condition condition) {
        return ((ValidityPeriodClosed)condition.validityPeriod()).to();
    }

    private boolean validityPeriodIsSupported(Condition condition) {
        return ValidityPeriodClosed.class.isInstance(condition.validityPeriod());
    }
}

