/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.base.diagnostic.TroubleHasException;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.CopyToClipboard;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticColors;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.FirstSelected;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereTable;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.NotificationDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.StatusFromException;
import org.eclipse.passage.lic.internal.jface.i18n.DiagnosticDialogMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class DiagnosticDialog
extends NotificationDialog {
    private final Diagnostic diagnostic;
    private final DiagnosticColors colors;
    private ButtonConfig error;

    public DiagnosticDialog(Shell shell, Diagnostic diagnostic) {
        super(shell);
        this.diagnostic = diagnostic;
        this.colors = new DiagnosticColors((Device)(shell == null ? Display.getCurrent() : shell.getDisplay()));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DiagnosticDialogMessages.DiagnosticDialog_title);
        shell.setImage(DiagnosticDialog.getDefaultImage());
        shell.setSize(1250, 500);
    }

    @Override
    protected void initButtons() {
        this.error = new ButtonConfig(1, this::viewError, DiagnosticDialogMessages.DiagnosticDialog_action_view_failure, DiagnosticDialogMessages.DiagnosticDialog_action_view_failure_tooltip, "");
        this.error.reside(this.buttons);
        new ButtonConfig(2, new CopyToClipboard(() -> ((DiagnosticDialog)this).getShell(), new Supplier[]{new DiagnosticExplained(this.diagnostic)}), DiagnosticDialogMessages.DiagnosticDialog_action_copy, DiagnosticDialogMessages.DiagnosticDialog_action_copy_tooltip, "").reside(this.buttons);
    }

    @Override
    protected void buildUI(Composite parent) {
        this.viewer = new HereTable<Trouble>(parent, Trouble.class, this::backdround).withColumn(DiagnosticDialogMessages.DiagnosticDialog_column_details, 900, Trouble::details).withColumn(DiagnosticDialogMessages.DiagnosticDialog_column_code, 50, trouble -> Integer.toString(trouble.code().code())).withColumn(DiagnosticDialogMessages.DiagnosticDialog_column_type, 250, trouble -> trouble.code().explanation()).viewer();
    }

    @Override
    protected void inplaceData() {
        this.viewer.setInput((Object)new SumOfLists().apply(this.diagnostic.severe(), this.diagnostic.bearable()));
    }

    @Override
    protected void updateButtonsEnablement() {
        this.getButton(this.error.id()).setEnabled(new TroubleHasException().test(this.selectedTrouble()));
    }

    @Override
    protected void initMessage() {
        this.setMessage(DiagnosticDialogMessages.DiagnosticDialog_description);
    }

    private void viewError() {
        Optional<Trouble> trouble = this.selectedTrouble();
        if (!trouble.isPresent()) {
            return;
        }
        if (!new TroubleHasException().test(trouble)) {
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)DiagnosticDialogMessages.DiagnosticDialog_error_title, (String)trouble.get().details(), (IStatus)new StatusFromException((Throwable)trouble.get().exception().get()).get());
    }

    private Optional<Trouble> selectedTrouble() {
        return new FirstSelected<Trouble>(this.viewer.getSelection(), Trouble.class).get();
    }

    private Color backdround(Object element, int column) {
        if (column != 1) {
            return null;
        }
        boolean failure = ((Trouble)element).exception().isPresent();
        boolean severe = this.diagnostic.severe().contains(element);
        return this.colors.get(severe, failure);
    }
}

