/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.convert;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.conditions.IssuerSignature;
import org.eclipse.passage.lic.api.conditions.LicenseSignatureIsEmpty;
import org.eclipse.passage.lic.licenses.model.api.Signature;
import org.eclipse.passage.lic.licenses.model.api.SignatureAttribute;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;

public final class EIssuerSignature
implements Supplier<Signature> {
    private final IssuerSignature signature;

    public EIssuerSignature(IssuerSignature signature) {
        Objects.requireNonNull(signature, "ELicenseSignature::signature");
        this.signature = signature;
    }

    @Override
    public Signature get() {
        if (new LicenseSignatureIsEmpty().test(this.signature)) {
            return null;
        }
        Signature esignature = LicensesFactory.eINSTANCE.createSignature();
        this.installAttributes(esignature);
        this.installParent(esignature);
        return esignature;
    }

    private void installParent(Signature esignature) {
        if (!this.signature.parent().isPresent()) {
            return;
        }
        esignature.setParent(new EIssuerSignature((IssuerSignature)this.signature.parent().get()).get());
    }

    private void installAttributes(Signature esignature) {
        this.signature.attributes().entrySet().stream().map(this::eattribute).forEach(arg_0 -> esignature.getAttributes().add(arg_0));
    }

    private SignatureAttribute eattribute(Map.Entry<String, String> attribute) {
        SignatureAttribute eattribute = LicensesFactory.eINSTANCE.createSignatureAttribute();
        eattribute.setName(attribute.getKey());
        eattribute.setValue(attribute.getValue());
        return eattribute;
    }
}

