/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.common.util.WeakInterningHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool<E>
extends WeakInterningHashSet<E> {
    private static final long serialVersionUID = 1L;
    protected int accessCount;
    protected int cleanupPeriod = 1000;
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected final AccessUnit.Queue<E> primaryAccessUnits;

    public Pool() {
        this(1031, (AccessUnit.Queue<E>)null);
    }

    public Pool(int minimumCapacity) {
        this(minimumCapacity, (AccessUnit.Queue<E>)null);
    }

    protected Pool(int minimumCapacity, AccessUnit.Queue<E> primaryAccessUnits) {
        super(minimumCapacity);
        this.primaryAccessUnits = primaryAccessUnits == null ? this.newDefaultAccessUnits() : primaryAccessUnits;
    }

    protected Pool(int minimumCapacity, AccessUnit.Queue<E> primaryAccessUnits, ReferenceQueue<Object> queue) {
        super(minimumCapacity, queue == null ? CommonUtil.REFERENCE_CLEARING_QUEUE : queue);
        this.primaryAccessUnits = primaryAccessUnits == null ? this.newDefaultAccessUnits() : primaryAccessUnits;
    }

    @Override
    protected boolean ensureCapacity() {
        if (this.size > this.threshold) {
            if (this.externalQueue != null) {
                int newThreshold = PRIME_CAPACITIES[this.capacityIndex + 1] * 3 / 4;
                if (newThreshold == this.threshold) {
                    this.grow(2 * this.size);
                    return true;
                }
                this.threshold = newThreshold;
                new ExternalRehasher(this, this.externalQueue).enqueue();
                return false;
            }
            this.rehash(this.newEntries(PRIME_CAPACITIES[++this.capacityIndex]));
            return true;
        }
        return false;
    }

    @Override
    protected WeakInterningHashSet.Entry<E> newExternalEntry(E object, int hashCode) {
        return new PoolEntry<E>(this, object, hashCode, this.externalQueue);
    }

    protected AccessUnit.Queue<E> newDefaultAccessUnits() {
        return new ObjectAccessUnit.Queue();
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    @Override
    protected WeakInterningHashSet.Entry<E> getEntry(int hashCode) {
        WeakInterningHashSet.Entry[] entries = this.entries;
        int index = Pool.index(hashCode, entries.length);
        WeakInterningHashSet.Entry entry = entries[index];
        while (entry != null) {
            if (hashCode == entry.hashCode) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected final void access(boolean isReadLocked, AccessUnit<E> accessUnit) {
        WeakInterningHashSet.Entry[] entries = this.entries;
        int hashCode = accessUnit.hashCode;
        int index = Pool.index(hashCode, entries.length);
        WeakInterningHashSet.Entry entry = entries[index];
        while (entry != null) {
            Object value;
            if (entry.hashCode == hashCode && (value = entry.get()) != null) {
                accessUnit.add(value, entry);
            }
            entry = entry.next;
        }
        if (!isReadLocked && this.internalQueue != null && ++this.accessCount == this.cleanupPeriod) {
            this.cleanup();
        }
    }

    protected final E addEntry(boolean isExclusive, E internalizedValue, AccessUnit<E> accessUnit) {
        if (!isExclusive) {
            this.writeLock.lock();
        }
        try {
            int hashCode = accessUnit.hashCode;
            int index = Pool.index(hashCode, this.entries.length);
            WeakInterningHashSet.Entry entry = this.entries[index];
            while (entry != null) {
                Object entryValue;
                if (hashCode == entry.hashCode && (entryValue = entry.get()) != null && accessUnit.rematches(entryValue, entry)) {
                    Object t = entryValue;
                    return (E)t;
                }
                entry = entry.next;
            }
            accessUnit.createdEntry = this.newEntry(internalizedValue, hashCode);
            this.addEntry(index, accessUnit.createdEntry);
            E e = internalizedValue;
            return e;
        }
        finally {
            if (!isExclusive) {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    protected void cleanup() {
        this.writeLock.lock();
        try {
            this.accessCount = 0;
            this.doCleanup();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void doCleanup() {
        super.cleanup();
    }

    @Override
    public void grow(int minimumCapacity) {
        this.writeLock.lock();
        try {
            this.accessCount = 0;
            super.grow(minimumCapacity);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean add(E value) {
        AccessUnit<E> accessUnit = this.primaryAccessUnits.pop(false);
        accessUnit.setValue(value);
        try {
            this.access(false, accessUnit);
            E otherValue = accessUnit.match();
            if (otherValue != null) {
                return false;
            }
            this.addEntry(false, accessUnit.getInternalizedValue(), accessUnit);
            boolean bl = accessUnit.createdEntry != null;
            return bl;
        }
        finally {
            accessUnit.reset(false);
        }
    }

    @Override
    public E intern(E value) {
        AccessUnit<E> accessUnit = this.primaryAccessUnits.pop(false);
        accessUnit.setValue(value);
        return this.doIntern(false, accessUnit);
    }

    protected E doIntern(boolean isExclusive, AccessUnit<E> accessUnit) {
        try {
            this.access(isExclusive, accessUnit);
            E otherValue = accessUnit.match();
            if (otherValue != null) {
                E e = otherValue;
                return e;
            }
            E e = this.addEntry(isExclusive, accessUnit.getInternalizedValue(), accessUnit);
            return e;
        }
        finally {
            accessUnit.reset(isExclusive);
        }
    }

    @Override
    public E get(E value) {
        AccessUnit<E> accessUnit = this.primaryAccessUnits.pop(false);
        accessUnit.setValue(value);
        this.readLock.lock();
        try {
            this.access(true, accessUnit);
            E e = accessUnit.match();
            return e;
        }
        finally {
            this.readLock.unlock();
            accessUnit.reset(false);
        }
    }

    @Override
    public boolean contains(Object value) {
        AccessUnit<E> accessUnit = this.primaryAccessUnits.pop(false);
        if (!accessUnit.setArbitraryValue(value)) {
            return false;
        }
        this.readLock.lock();
        try {
            this.access(true, accessUnit);
            boolean bl = accessUnit.match() != null;
            return bl;
        }
        finally {
            this.readLock.unlock();
            accessUnit.reset(false);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return super.iterator();
    }

    @Override
    public boolean equals(Object o) {
        Lock lock = this.internalQueue == null ? this.readLock : this.writeLock;
        lock.lock();
        try {
            boolean bl = super.equals(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int hashCode() {
        Lock lock = this.internalQueue == null ? this.readLock : this.writeLock;
        lock.lock();
        try {
            int n = super.hashCode();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        Lock lock = this.internalQueue == null ? this.readLock : this.writeLock;
        lock.lock();
        try {
            Object[] objectArray = super.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Lock lock = this.internalQueue == null ? this.readLock : this.writeLock;
        lock.lock();
        try {
            T[] TArray = super.toArray(a);
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Lock lock = this.internalQueue == null ? this.readLock : this.writeLock;
        lock.lock();
        try {
            boolean bl = super.containsAll(collection);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        Lock lock = this.internalQueue == null ? this.readLock : this.writeLock;
        lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AccessUnit<E> {
        protected final Queue<E> queue;
        protected AccessUnit<E> next;
        protected int hashCode;
        protected Object[] values = new Object[10];
        protected int valuesLength;
        protected int matchingIndex = -1;
        protected WeakInterningHashSet.Entry<E> createdEntry;
        protected WeakInterningHashSet.Entry<E>[] entries = new WeakInterningHashSet.Entry[10];

        protected AccessUnit(Queue<E> queue) {
            this.queue = queue;
        }

        protected abstract E getValue();

        protected abstract void setValue(E var1);

        protected abstract boolean setArbitraryValue(Object var1);

        protected WeakInterningHashSet.Entry<E> getEntry() {
            if (this.createdEntry != null) {
                return this.createdEntry;
            }
            if (this.matchingIndex != -1) {
                return this.entries[this.matchingIndex];
            }
            return null;
        }

        public E getInternalizedValue() {
            return this.getValue();
        }

        protected boolean matches(E value) {
            E accessValue = this.getValue();
            return accessValue == value || accessValue.equals(value);
        }

        public final boolean rematches(E value, WeakInterningHashSet.Entry<E> entry) {
            Object[] values = this.values;
            int i = 0;
            int valuesLength = this.valuesLength;
            while (i < valuesLength) {
                if (value == values[i]) {
                    return false;
                }
                ++i;
            }
            if (this.matches(value)) {
                this.add(value, entry);
                this.matchingIndex = this.valuesLength - 1;
                return true;
            }
            return false;
        }

        public E match() {
            Object[] values = this.values;
            int i = 0;
            int valuesLength = this.valuesLength;
            while (i < valuesLength) {
                Object otherValue = values[i];
                if (this.matches(otherValue)) {
                    this.matchingIndex = i;
                    return (E)otherValue;
                }
                ++i;
            }
            this.matchingIndex = -1;
            return null;
        }

        public void add(E value, WeakInterningHashSet.Entry<E> entry) {
            int length = this.values.length;
            if (this.valuesLength == length) {
                Object[] newValues = new Object[2 * length];
                System.arraycopy(this.values, 0, newValues, 0, this.valuesLength);
                this.values = newValues;
            }
            if (this.entries == null || this.valuesLength == this.entries.length) {
                WeakInterningHashSet.Entry[] newEntries = new WeakInterningHashSet.Entry[2 * length];
                if (this.entries != null) {
                    System.arraycopy(this.entries, 0, newEntries, 0, this.valuesLength);
                }
                this.entries = newEntries;
            }
            this.values[this.valuesLength] = value;
            this.entries[this.valuesLength++] = entry;
        }

        public void reset(boolean isExclusive) {
            int valuesLength = this.valuesLength;
            if (valuesLength > 0) {
                Object[] values = this.values;
                WeakInterningHashSet.Entry<E>[] entries = this.entries;
                int i = 0;
                while (i < valuesLength) {
                    values[i] = null;
                    entries[i] = null;
                    ++i;
                }
                this.valuesLength = 0;
            }
            this.matchingIndex = -1;
            this.createdEntry = null;
            if (this.queue != null) {
                this.queue.push(this, isExclusive);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static abstract class Queue<E>
        extends AtomicReference<AccessUnit<E>> {
            private static final long serialVersionUID = 1L;
            protected final AccessUnit<E> GUARD = new AccessUnit<E>(this){

                @Override
                protected E getValue() {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void setValue(E value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected boolean setArbitraryValue(Object value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void reset(boolean isExclusive) {
                    throw new UnsupportedOperationException();
                }
            };
            protected AccessUnit<E> exclusiveAccessUnit;

            protected Queue() {
            }

            public AccessUnit<E> pop(boolean isExclusive) {
                AccessUnit accessUnit;
                if (isExclusive) {
                    AccessUnit<E> accessUnit2 = this.exclusiveAccessUnit;
                    if (accessUnit2 == null) {
                        return this.newAccessUnit();
                    }
                    this.exclusiveAccessUnit = accessUnit2.next;
                    return accessUnit2;
                }
                do {
                    if ((accessUnit = (AccessUnit)this.get()) != null) continue;
                    return this.newAccessUnit();
                } while (accessUnit == this.GUARD || !this.compareAndSet(accessUnit, this.GUARD));
                this.set(accessUnit.next);
                return accessUnit;
            }

            public void push(AccessUnit<E> accessUnit, boolean isExclusive) {
                if (isExclusive) {
                    accessUnit.next = this.exclusiveAccessUnit;
                    this.exclusiveAccessUnit = accessUnit;
                } else {
                    AccessUnit headAccessUnit;
                    while ((headAccessUnit = (accessUnit.next = (AccessUnit)this.get())) == this.GUARD || !this.compareAndSet(headAccessUnit, accessUnit)) {
                    }
                }
            }

            protected abstract AccessUnit<E> newAccessUnit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExternalRehasher<E>
    extends WeakReference<Pool<E>> {
        public ExternalRehasher(Pool<E> pool, ReferenceQueue<Object> queue) {
            super(pool, queue);
        }

        @Override
        public void clear() {
            Pool pool = (Pool)this.get();
            if (pool != null) {
                block15: {
                    int expectedCapacityIndex = pool.capacityIndex;
                    int expectedSize = pool.size;
                    int expectedCapacity = PRIME_CAPACITIES[expectedCapacityIndex + 1];
                    WeakInterningHashSet.Entry[] oldEntries = pool.entries;
                    WeakInterningHashSet.Entry[] expectedEntries = new WeakInterningHashSet.Entry[expectedSize];
                    int[] newIndices = new int[expectedSize];
                    int entryCount = 0;
                    int i = 0;
                    int length = oldEntries.length;
                    block3: while (i < length) {
                        WeakInterningHashSet.Entry entry = oldEntries[i];
                        while (entry != null) {
                            expectedEntries[entryCount] = entry;
                            newIndices[entryCount++] = Pool.index(entry.hashCode, expectedCapacity);
                            if (entryCount >= expectedSize) break block3;
                            entry = entry.next;
                        }
                        ++i;
                    }
                    pool.writeLock.lock();
                    try {
                        if (pool.entries != oldEntries || pool.capacityIndex != expectedCapacityIndex) break block15;
                        int newCapacity = PRIME_CAPACITIES[pool.capacityIndex + 1];
                        int newThreshold = newCapacity * 3 / 4;
                        if (pool.size > newThreshold) {
                            pool.grow(2 * pool.size);
                            break block15;
                        }
                        ++pool.capacityIndex;
                        int newSize = pool.containsNull ? 1 : 0;
                        pool.entries = pool.newEntries(expectedCapacity);
                        int i2 = 0;
                        int entryIndex = 0;
                        int length2 = oldEntries.length;
                        while (i2 < length2) {
                            WeakInterningHashSet.Entry nextEntry;
                            WeakInterningHashSet.Entry entry = nextEntry = oldEntries[i2];
                            while (entry != null) {
                                block16: {
                                    nextEntry = entry.next;
                                    while (entryIndex < entryCount) {
                                        WeakInterningHashSet.Entry expectedEntry = expectedEntries[entryIndex];
                                        if (expectedEntry == entry) {
                                            int newIndex = newIndices[entryIndex++];
                                            pool.putEntry(newIndex, entry);
                                            ++newSize;
                                        } else {
                                            if (expectedEntry.get() == null && !expectedEntry.isEnqueued()) {
                                                ++entryIndex;
                                                continue;
                                            }
                                            if (!entry.isEnqueued()) {
                                                pool.putEntry(Pool.index(entry.hashCode, newCapacity), entry);
                                                ++newSize;
                                            }
                                        }
                                        break block16;
                                    }
                                    if (entry.get() != null) {
                                        pool.putEntry(Pool.index(entry.hashCode, newCapacity), entry);
                                        ++newSize;
                                    }
                                }
                                entry = nextEntry;
                            }
                            ++i2;
                        }
                        pool.size = newSize;
                        pool.threshold = newThreshold;
                        ++pool.modCount;
                    }
                    finally {
                        pool.writeLock.unlock();
                    }
                }
                super.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjectAccessUnit<E>
    extends AccessUnit<E> {
        protected E value;

        public ObjectAccessUnit(AccessUnit.Queue<E> queue) {
            super(queue);
        }

        @Override
        protected E getValue() {
            return this.value;
        }

        @Override
        protected void setValue(E value) {
            this.value = value;
            this.hashCode = value.hashCode();
        }

        protected void setValue(E value, int hashCode) {
            this.value = value;
            this.hashCode = hashCode;
        }

        @Override
        protected boolean setArbitraryValue(Object value) {
            this.setValue(value);
            return true;
        }

        @Override
        public void reset(boolean isExclusive) {
            this.value = null;
            super.reset(isExclusive);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class Queue<E>
        extends AccessUnit.Queue<E> {
            private static final long serialVersionUID = 1L;

            protected Queue() {
            }

            @Override
            protected AccessUnit<E> newAccessUnit() {
                return new ObjectAccessUnit(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PoolEntry<E>
    extends WeakInterningHashSet.Entry<E> {
        protected final Pool<E> pool;

        public PoolEntry(Pool<E> pool, E object, int hashCode, ReferenceQueue<Object> queue) {
            super(object, hashCode, queue);
            this.pool = pool;
        }

        @Override
        public void clear() {
            Pool<E> pool = this.pool;
            pool.writeLock.lock();
            try {
                this.clear(pool);
            }
            finally {
                pool.writeLock.unlock();
            }
        }
    }
}

