/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.base.io.PassageFileExtension;

public final class FileKeyKeeper
implements KeyKeeper {
    private final Path key;

    public FileKeyKeeper(Path key) throws LicensingException {
        Objects.requireNonNull(key, "FileKeyKeeper::key");
        this.key = key;
        this.validateKeyFile();
    }

    public LicensedProduct id() {
        throw new UnsupportedOperationException("Reads the only key from the given location, product is unknown. Is not intended to be used.");
    }

    public InputStream productPublicKey() throws LicensingException {
        try {
            return new FileInputStream(this.key.toFile());
        }
        catch (Exception e) {
            throw new LicensingException((Throwable)e);
        }
    }

    private void validateKeyFile() throws LicensingException {
        if (!Files.exists(this.key, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s is expected to exist", this.key.toString()));
        }
        if (!Files.isRegularFile(this.key, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s is expected to be a regular file", this.key.toString()));
        }
        if (!Files.isReadable(this.key)) {
            throw new IllegalArgumentException(String.format("Lack of access rights: %s cannot be read", this.key.toString()));
        }
        if (!this.key.getFileName().toString().endsWith(new PassageFileExtension.PublicKey().get())) {
            throw new IllegalArgumentException(String.format("%s has incorrect format ", this.key.toString()));
        }
    }
}

