/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.base.diagnostic.RequirementStatus;
import org.eclipse.passage.lic.base.diagnostic.RequirementsCoverage;
import org.eclipse.passage.lic.base.restrictions.ExaminationExplained;
import org.eclipse.passage.lic.equinox.ProductContacts;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.CertificateSummary;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.CopyToClipboard;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.GoodIntention;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereTable;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.NotificationDialog;
import org.eclipse.passage.lic.internal.jface.i18n.LicenseStatusDialogMessages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseLicenseStatusDialog
extends NotificationDialog {
    protected final ExaminationCertificate certificate;
    protected final Diagnostic diagnostic;
    private GoodIntention intention = new GoodIntention.Nope();
    private StyledText notice;

    protected BaseLicenseStatusDialog(Shell shell, ExaminationCertificate certificate, Diagnostic diagnostic) {
        super(shell);
        this.certificate = certificate;
        this.diagnostic = diagnostic;
    }

    public final GoodIntention goodIntention() {
        return this.intention;
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(LicenseStatusDialogMessages.LicenseStatusDialog_title);
        shell.setImage(BaseLicenseStatusDialog.getDefaultImage());
        shell.setSize(1200, 600);
    }

    @Override
    protected final void buildUI(Composite parent) {
        this.viewer = new HereTable<RequirementStatus>(parent, RequirementStatus.class).withColumn(LicenseStatusDialogMessages.LicenseStatusDialog_column_id, 600, RequirementStatus::feature).withColumn(LicenseStatusDialogMessages.LicenseStatusDialog_column_status, 500, RequirementStatus::status).viewer();
        this.notice = new StyledText(parent, 2056);
        this.notice.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    @Override
    protected final void inplaceData() {
        this.viewer.setInput((Object)new RequirementsCoverage(this.certificate).get());
        this.notice.setText(new ProductContacts().get());
    }

    @Override
    protected final void initButtons() {
        int button = 1;
        new ButtonConfig(button++, this::requestLicense, LicenseStatusDialogMessages.LicenseStatusDialog_intention_request, LicenseStatusDialogMessages.LicenseStatusDialog_intention_request_tooltip, "").reside(this.buttons);
        new ButtonConfig(button++, this::importLicense, LicenseStatusDialogMessages.LicenseStatusDialog_intention_import, LicenseStatusDialogMessages.LicenseStatusDialog_intention_import_tooltip, "").reside(this.buttons);
        new ButtonConfig(button++, this.copy(), LicenseStatusDialogMessages.LicenseStatusDialog_intention_copy, LicenseStatusDialogMessages.LicenseStatusDialog_intention_copy_tooltip, "").reside(this.buttons);
        if (this.haveUnacceptedAgreements()) {
            new ButtonConfig(button++, this::exposeAgreements, LicenseStatusDialogMessages.LicenseStatusDialog_intention_accept, LicenseStatusDialogMessages.LicenseStatusDialog_intention_accept_tooltip, "").reside(this.buttons);
        }
        if (!new NoErrors().test(this.diagnostic)) {
            new ButtonConfig(button++, this::diagnose, LicenseStatusDialogMessages.LicenseStatusDialog_intention_diagnose, LicenseStatusDialogMessages.LicenseStatusDialog_intention_diagnose_tooltip, "").reside(this.buttons);
        }
    }

    @Override
    protected final void updateButtonsEnablement() {
    }

    @Override
    protected final void initMessage() {
        new CertificateSummary(this.certificate).accept(this);
    }

    protected abstract GoodIntention requestLicenseIntention();

    protected abstract GoodIntention importLicenseIntention();

    protected abstract GoodIntention diagnoseIntention();

    protected abstract GoodIntention exposeLicenseAgreementsIntention(Collection<AgreementToAccept> var1);

    private void requestLicense() {
        this.intention = this.requestLicenseIntention();
        super.okPressed();
    }

    private void importLicense() {
        this.intention = this.importLicenseIntention();
        super.okPressed();
    }

    private void diagnose() {
        this.intention = this.diagnoseIntention();
        super.okPressed();
    }

    private void exposeAgreements() {
        this.intention = this.exposeLicenseAgreementsIntention(this.toExpose(this.certificate.agreements()));
        super.okPressed();
    }

    private Collection<AgreementToAccept> toExpose(Collection<AgreementToAccept> agreements) {
        return agreements.stream().filter(this::toExpose).collect(Collectors.toList());
    }

    private boolean toExpose(AgreementToAccept agreement) {
        return !agreement.acceptance().accepted() && !agreement.acceptance().error().isPresent();
    }

    private boolean haveUnacceptedAgreements() {
        return this.certificate.agreements().stream().filter(this::toExpose).findAny().isPresent();
    }

    private Runnable copy() {
        return new CopyToClipboard(() -> ((BaseLicenseStatusDialog)this).getShell(), new Supplier[]{new ExaminationExplained(this.certificate), new DiagnosticExplained(this.diagnostic)});
    }
}

