/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.restrictions;

import java.util.Objects;
import org.eclipse.passage.lic.api.registry.ServiceId;

public abstract class RestrictionLevel
implements ServiceId {
    private final String identifier;

    protected RestrictionLevel(String identifier) {
        Objects.requireNonNull(identifier, "Identifier is mandatory for restriction level");
        this.identifier = identifier.trim().toLowerCase();
    }

    public final String identifier() {
        return this.identifier;
    }

    public final int hashCode() {
        return Objects.hash(this.identifier());
    }

    public final boolean equals(Object object) {
        if (!RestrictionLevel.class.isInstance(object)) {
            return false;
        }
        return this.identifier.equals(((RestrictionLevel)object).identifier);
    }

    public final String toString() {
        return this.identifier;
    }

    public static final class Error
    extends RestrictionLevel {
        public Error() {
            super("error");
        }
    }

    public static final class Fatal
    extends RestrictionLevel {
        public Fatal() {
            super("fatal");
        }
    }

    public static final class Info
    extends RestrictionLevel {
        public Info() {
            super("info");
        }
    }

    public static final class Of
    extends RestrictionLevel {
        public Of(String identifier) {
            super(identifier);
        }
    }

    public static final class Warning
    extends RestrictionLevel {
        public Warning() {
            super("warn");
        }
    }
}

