/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.licenses.edit;

import java.util.Date;
import java.util.function.Function;
import org.eclipse.passage.lic.licenses.edit.DatePrinted;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriod;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;

public final class ClosedPeriodPrinted {
    private final String from;
    private final String until;

    public ClosedPeriodPrinted(ValidityPeriod valid) {
        ValidityPeriodClosed period = this.closed(valid);
        this.from = this.date(period, ValidityPeriodClosed::getFrom);
        this.until = this.date(period, ValidityPeriodClosed::getUntil);
    }

    private String date(ValidityPeriodClosed period, Function<ValidityPeriodClosed, Date> date) {
        return period == null ? "unknown" : new DatePrinted(date.apply(period)).get();
    }

    private ValidityPeriodClosed closed(ValidityPeriod period) {
        if (period instanceof ValidityPeriodClosed) {
            return (ValidityPeriodClosed)period;
        }
        return null;
    }

    public String from() {
        return this.from;
    }

    public String until() {
        return this.until;
    }
}

