/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.mining.LicenseReadingService;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.base.conditions.CalmedDown;

public final class LicenseConditions
implements Supplier<ServiceInvocationResult<Collection<ConditionPack>>> {
    private final Path file;
    private final Supplier<ServiceInvocationResult<LicenseReadingService>> owner;
    private final Libraries libraries;

    public LicenseConditions(Path file, Supplier<ServiceInvocationResult<LicenseReadingService>> provider, Libraries libraries) {
        this.file = file;
        this.owner = provider;
        this.libraries = libraries;
    }

    @Override
    public ServiceInvocationResult<Collection<ConditionPack>> get() {
        return new CalmedDown(this.sum().apply(this.fromProduct(), this.fromLibraries())).get();
    }

    private ServiceInvocationResult<Collection<ConditionPack>> fromProduct() {
        ServiceInvocationResult<LicenseReadingService> reader = this.owner.get();
        if (!reader.data().isPresent()) {
            return new BaseServiceInvocationResult<Collection<ConditionPack>>(reader.diagnostic());
        }
        return ((LicenseReadingService)reader.data().get()).read(this.file);
    }

    private ServiceInvocationResult<Collection<ConditionPack>> fromLibraries() {
        Optional<ServiceInvocationResult<List<LicenseReadingService>>> request = this.libraries.licenseReadingServices();
        if (!request.isPresent()) {
            return new BaseServiceInvocationResult<Collection<ConditionPack>>(Collections.emptyList());
        }
        ServiceInvocationResult<List<LicenseReadingService>> services = request.get();
        if (!services.data().isPresent()) {
            return new BaseServiceInvocationResult<Collection<ConditionPack>>(services.diagnostic());
        }
        return (ServiceInvocationResult)((List)services.data().get()).stream().map(service -> service.read(this.file)).reduce(this.sum()).get();
    }

    private BaseServiceInvocationResult.Sum<Collection<ConditionPack>> sum() {
        return new BaseServiceInvocationResult.Sum<Collection<ConditionPack>>(new SumOfCollections());
    }
}

