/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.mining;

import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.api.conditions.mining.ConditionTransportRegistry;
import org.eclipse.passage.lic.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.api.conditions.mining.MiningTool;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.base.conditions.mining.PersonalLicenseMiningTool;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class PersonalLicenseMiningEquipment
implements MiningEquipment {
    private final KeyKeeperRegistry keys;
    private final StreamCodecRegistry codecs;
    private final ConditionTransportRegistry transports;

    public PersonalLicenseMiningEquipment(KeyKeeperRegistry keys, StreamCodecRegistry codecs, ConditionTransportRegistry transports) {
        this.keys = keys;
        this.codecs = codecs;
        this.transports = transports;
    }

    public MiningTool tool(LicensedProduct product, ConditionMiningTarget miner) throws LicensingException {
        return new PersonalLicenseMiningTool(this.key(product), this.codec(product), this.transport(product), miner);
    }

    private KeyKeeper key(LicensedProduct product) throws LicensingException {
        if (!((Registry)this.keys.get()).hasService((ServiceId)product)) {
            throw new LicensingException(String.format(BaseMessages.getString("LicenseReadingTool.error_no_key_keeper"), product));
        }
        return (KeyKeeper)((Registry)this.keys.get()).service((ServiceId)product);
    }

    private StreamCodec codec(LicensedProduct product) throws LicensingException {
        if (!((Registry)this.codecs.get()).hasService((ServiceId)product)) {
            throw new LicensingException(String.format(BaseMessages.getString("LicenseReadingTool.error_no_stream_codec"), product));
        }
        return (StreamCodec)((Registry)this.codecs.get()).service((ServiceId)product);
    }

    private ConditionTransport transport(LicensedProduct product) throws LicensingException {
        ContentType.Xml contentType = new ContentType.Xml();
        if (!((Registry)this.transports.get()).hasService((ServiceId)contentType)) {
            throw new LicensingException(String.format(BaseMessages.getString("LicenseReadingTool.error_no_transport"), product, contentType));
        }
        return (ConditionTransport)((Registry)this.transports.get()).service((ServiceId)contentType);
    }
}

