/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions.mining;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.NoLicenses;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnInfrastructureDenial;
import org.eclipse.passage.lic.base.io.FileCollection;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.i18n.ConditionMiningMessages;

public abstract class LocalConditions
implements MinedConditions {
    private final ConditionMiningTarget id;
    private final MiningEquipment equipment;
    private final PassageFileExtension scope;

    protected LocalConditions(ConditionMiningTarget id, MiningEquipment equipment, PassageFileExtension scope) {
        String cls = this.getClass().getSimpleName();
        Objects.requireNonNull(id, cls + "::id");
        Objects.requireNonNull(equipment, cls + "::equipment");
        Objects.requireNonNull(scope, cls + "::scope");
        this.id = id;
        this.equipment = equipment;
        this.scope = scope;
    }

    protected LocalConditions(ConditionMiningTarget id, MiningEquipment equipment) {
        this(id, equipment, new PassageFileExtension.LicenseEncrypted());
    }

    public final ConditionMiningTarget id() {
        return this.id;
    }

    public final ServiceInvocationResult<Collection<ConditionPack>> all(LicensedProduct product) {
        try {
            Collection<Path> licenses = this.licenses(product);
            if (licenses.isEmpty()) {
                return this.noLicenses(product);
            }
            return this.equipment.tool(product, this.id).mine(licenses);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new ServiceFailedOnInfrastructureDenial(), ConditionMiningMessages.getString("LocalConditions.failed"), (Exception)((Object)e)));
        }
    }

    private ServiceInvocationResult<Collection<ConditionPack>> noLicenses(LicensedProduct product) {
        return new BaseServiceInvocationResult<Collection<ConditionPack>>((Diagnostic)new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new NoLicenses(), String.format(ConditionMiningMessages.getString("LocalConditions.no_licenses"), this.base(product).get().toAbsolutePath())))), Collections.emptyList());
    }

    private Collection<Path> licenses(LicensedProduct product) throws LicensingException {
        return new FileCollection(this.base(product), this.scope).get();
    }

    protected abstract Supplier<Path> base(LicensedProduct var1);
}

