/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementState;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.agreements.GlobalAgreement;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.api.restrictions.PermissionsExaminationService;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.access.Permissions;
import org.eclipse.passage.lic.base.access.SumOfCertificates;
import org.eclipse.passage.lic.base.agreements.AgreementAcceptanceDemand;
import org.eclipse.passage.lic.base.agreements.BaseAgreementToAccept;
import org.eclipse.passage.lic.base.agreements.MinedAgreement;
import org.eclipse.passage.lic.base.agreements.UnacceptedAgreementRestriction;
import org.eclipse.passage.lic.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.base.restrictions.BaseExaminationCertificate;
import org.eclipse.passage.lic.internal.base.i18n.AccessCycleMessages;

public final class Restrictions
implements Supplier<ServiceInvocationResult<ExaminationCertificate>> {
    private final Registry<StringServiceId, PermissionsExaminationService> registry;
    private final AgreementAcceptanceService acceptance;
    private final Collection<Requirement> requirements;
    private final Permissions.AppliedLicenses permissions;
    private final LicensedProduct product;

    public Restrictions(LicensedProduct product, Registry<StringServiceId, PermissionsExaminationService> registry, AgreementAcceptanceService acceptance, Collection<Requirement> requirements, Permissions.AppliedLicenses permissions) {
        this.product = product;
        this.registry = registry;
        this.acceptance = acceptance;
        this.requirements = requirements;
        this.permissions = permissions;
    }

    @Override
    public ServiceInvocationResult<ExaminationCertificate> get() {
        if (this.registry.services().isEmpty()) {
            return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new NoServicesOfType(AccessCycleMessages.getString("Restrictions.type")), AccessCycleMessages.getString("Restrictions.no_services")));
        }
        return new BaseServiceInvocationResult<ExaminationCertificate>(new SumOfCertificates().apply(this.permissionBasedCertificate(), this.agreementsBasedCertificate()));
    }

    private ExaminationCertificate permissionBasedCertificate() {
        return this.registry.services().stream().map(service -> service.examine(this.requirements, this.permissions.permissions())).reduce(new SumOfCertificates()).get();
    }

    private ExaminationCertificate agreementsBasedCertificate() {
        List<AgreementToAccept> agreements = this.permissions.agreements().stream().map(this::agreementToAccept).collect(Collectors.toList());
        return new BaseExaminationCertificate(Collections.emptyMap(), this.restrictions(agreements), agreements);
    }

    private AgreementToAccept agreementToAccept(GlobalAgreement agreement) {
        MinedAgreement definition = new MinedAgreement(agreement);
        return new BaseAgreementToAccept(new AgreementAcceptanceDemand(definition, this.product), definition, this.acceptanceState(agreement));
    }

    private AgreementState acceptanceState(GlobalAgreement agreement) {
        return this.acceptance.accepted(agreement.content(), agreement.name());
    }

    private Collection<Restriction> restrictions(List<AgreementToAccept> agreements) {
        return agreements.stream().filter(agreement -> !agreement.acceptance().accepted()).map(agreement -> new UnacceptedAgreementRestriction(this.product, (AgreementToAccept)agreement).get()).collect(Collectors.toList());
    }
}

