/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.oshi;

import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionTokenAssessmentService;
import org.eclipse.passage.lic.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironment;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironmentRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.base.inspection.BaseEnvironmentProperty;
import org.eclipse.passage.lic.internal.oshi.i18n.AssessmentMessages;

public final class HardwareAssessmentService
implements ExpressionTokenAssessmentService {
    private final EvaluationType type = new EvaluationType.Hardware();
    private RuntimeEnvironmentRegistry environments;

    public HardwareAssessmentService(RuntimeEnvironmentRegistry environments) {
        this.environments = environments;
    }

    public EvaluationType id() {
        return this.type;
    }

    public boolean equal(String key, String value) throws ExpressionEvaluationException {
        try {
            return this.hardware().isAssuptionTrue((EnvironmentProperty)new BaseEnvironmentProperty.Of(key), value);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(String.format(AssessmentMessages.HardwareAssessmentService_error_on_assessment, key, value), (Throwable)e);
        }
    }

    private RuntimeEnvironment hardware() throws LicensingException {
        if (((Registry)this.environments.get()).hasService((ServiceId)this.type)) {
            return (RuntimeEnvironment)((Registry)this.environments.get()).service((ServiceId)this.type);
        }
        throw new LicensingException(String.format(AssessmentMessages.HardwareAssessmentService_no_hw_inspector, this.type));
    }
}

