/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.internal.api.conditions.IssuerSignature;
import org.eclipse.passage.lic.internal.base.conditions.BaseIssuerSignature;

public final class BaseConditionOrigin
implements ConditionOrigin {
    private final ConditionMiningTarget miner;
    private final String coordinates;
    private final IssuerSignature signature;

    public BaseConditionOrigin(ConditionMiningTarget miner, String coordinates) {
        this(miner, coordinates, new BaseIssuerSignature());
    }

    public BaseConditionOrigin(ConditionMiningTarget miner, String coordinates, Optional<IssuerSignature> signature) {
        this(miner, coordinates, signature.orElse(new BaseIssuerSignature()));
    }

    public BaseConditionOrigin(ConditionMiningTarget miner, String coordinates, IssuerSignature signature) {
        Objects.requireNonNull(miner, "BaseConditionOrigin::miner");
        Objects.requireNonNull(coordinates, "BaseConditionOrigin::coordinates");
        Objects.requireNonNull(signature, "BaseConditionOrigin::signature");
        this.miner = miner;
        this.coordinates = coordinates;
        this.signature = signature;
    }

    public ConditionMiningTarget miner() {
        return this.miner;
    }

    public String coordinates() {
        return this.coordinates;
    }

    public IssuerSignature signature() {
        return this.signature;
    }
}

