/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.conditions.MatchingRule;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleCompatible;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleDefault;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleEquivalent;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleGreaterOrEqual;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRulePerfect;

public final class MatchingRuleForIdentifier
implements Supplier<MatchingRule> {
    private final String identifier;

    public MatchingRuleForIdentifier(String identifier) {
        Objects.requireNonNull(identifier, "MatchingRuleForIdentifier::identifier");
        this.identifier = identifier;
    }

    public MatchingRuleForIdentifier(Optional<String> identifier) {
        Objects.requireNonNull(identifier, "MatchingRuleForIdentifier::identifier");
        this.identifier = identifier.isPresent() ? identifier.get() : new MatchingRuleDefault().identifier();
    }

    @Override
    public MatchingRule get() {
        switch (this.identifier.toLowerCase()) {
            case "compatible": {
                return new MatchingRuleCompatible();
            }
            case "equivalent": {
                return new MatchingRuleEquivalent();
            }
            case "greaterorequal": {
                return new MatchingRuleGreaterOrEqual();
            }
            case "perfect": {
                return new MatchingRulePerfect();
            }
        }
        return new MatchingRuleDefault();
    }
}

