/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransportRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.api.io.Hashes;
import org.eclipse.passage.lic.internal.api.io.HashesRegistry;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.hc.i18n.MineMessages;

public final class Equipment {
    private final KeyKeeperRegistry keys;
    private final StreamCodecRegistry codecs;
    private final ConditionTransportRegistry transports;
    private final HashesRegistry hashes;

    public Equipment(KeyKeeperRegistry keys, StreamCodecRegistry codecs, ConditionTransportRegistry transports, HashesRegistry hashes) {
        this.keys = keys;
        this.codecs = codecs;
        this.transports = transports;
        this.hashes = hashes;
    }

    public KeyKeeperRegistry keys() {
        return this.keys;
    }

    public StreamCodecRegistry codecs() {
        return this.codecs;
    }

    public ConditionTransportRegistry transports() {
        return this.transports;
    }

    public HashesRegistry hashes() {
        return this.hashes;
    }

    public KeyKeeper keeper(LicensedProduct product) {
        return (KeyKeeper)((Registry)this.keys.get()).service((ServiceId)product);
    }

    public Hashes hash(String algorithm) {
        return (Hashes)((Registry)this.hashes.get()).service((ServiceId)new StringServiceId(algorithm));
    }

    public ConditionTransport transport(ContentType contentType) throws LicensingException {
        if (!((Registry)this.transports.get()).hasService((ServiceId)contentType)) {
            throw new LicensingException(String.format(MineMessages.DecryptedConditions_no_transport_for_content_type, contentType.contentType()));
        }
        return (ConditionTransport)((Registry)this.transports.get()).service((ServiceId)contentType);
    }
}

