/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;

public class SignatureSubpacket {
    int type;
    boolean critical;
    boolean isLongLength;
    protected byte[] data;

    protected SignatureSubpacket(int n, boolean bl, boolean bl2, byte[] byArray) {
        this.type = n;
        this.critical = bl;
        this.isLongLength = bl2;
        this.data = byArray;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isLongLength() {
        return this.isLongLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n = this.data.length + 1;
        if (this.isLongLength) {
            outputStream.write(255);
            outputStream.write((byte)(n >> 24));
            outputStream.write((byte)(n >> 16));
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
        } else if (n < 192) {
            outputStream.write((byte)n);
        } else if (n <= 8383) {
            outputStream.write((byte)(((n -= 192) >> 8 & 0xFF) + 192));
            outputStream.write((byte)n);
        } else {
            outputStream.write(255);
            outputStream.write((byte)(n >> 24));
            outputStream.write((byte)(n >> 16));
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
        }
        if (this.critical) {
            outputStream.write(0x80 | this.type);
        } else {
            outputStream.write(this.type);
        }
        outputStream.write(this.data);
    }
}

