/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl.acquire;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.internal.api.acquire.LicenseAcquisitionService;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.impl.HttpClient;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.internal.hc.remote.impl.acquire.RemoteAcquire;
import org.eclipse.passage.lic.internal.hc.remote.impl.acquire.RemoteRelease;

public final class RemoteAcquisitionService<C extends Connection>
implements LicenseAcquisitionService {
    private final KeyKeeperRegistry keys;
    private final StreamCodecRegistry codecs;
    private final ConditionMiningTarget target = new ConditionMiningTarget.Remote();
    private final Supplier<Client<C, GrantAcquisition>> acquire;
    private final Supplier<Client<C, Boolean>> release;
    private final Supplier<Path> source;

    public RemoteAcquisitionService(KeyKeeperRegistry keys, StreamCodecRegistry codecs, Supplier<Client<C, GrantAcquisition>> acquire, Supplier<Client<C, Boolean>> release, Supplier<Path> source) {
        this.keys = keys;
        this.codecs = codecs;
        this.acquire = acquire;
        this.release = release;
        this.source = source;
    }

    public RemoteAcquisitionService(KeyKeeperRegistry keys, StreamCodecRegistry codecs) {
        this(keys, codecs, HttpClient::new, HttpClient::new, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    public ConditionMiningTarget id() {
        return this.target;
    }

    public ServiceInvocationResult<GrantAcquisition> acquire(LicensedProduct product, String feature) {
        return new RemoteAcquire<C>(this.keys, this.codecs, this.acquire, this.source).request(new RemoteServiceData.OfFeature(product, feature));
    }

    public ServiceInvocationResult<Boolean> release(LicensedProduct product, GrantAcquisition acquisition) {
        return new RemoteRelease<C>(this.keys, this.codecs, this.release, this.source).request(new RemoteServiceData.WithPayload<GrantAcquisition>(product, acquisition));
    }
}

