/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.EvaluationType;
import org.eclipse.passage.lic.internal.api.inspection.RuntimeEnvironment;
import org.eclipse.passage.lic.internal.equinox.Environments;
import org.eclipse.passage.lic.internal.jface.i18n.EnvironmentStateDialogMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public final class EnvironmentStateDialog
extends Dialog {
    private final List<RuntimeEnvironment> environments = new ArrayList<RuntimeEnvironment>(new Environments().get());

    public EnvironmentStateDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        TabFolder folder = new TabFolder(parent, 2048);
        Rectangle clientArea = parent.getClientArea();
        folder.setLocation(clientArea.x, clientArea.y);
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.environments.forEach(env -> this.installTabPerEnvironment(folder, (RuntimeEnvironment)env));
        folder.pack();
        return folder;
    }

    private void installTabPerEnvironment(TabFolder folder, RuntimeEnvironment environment) {
        TabItem item = new TabItem(folder, 0);
        item.setText(((EvaluationType)environment.id()).identifier());
        item.setControl((Control)this.content(folder, environment));
    }

    private Composite content(TabFolder folder, RuntimeEnvironment environment) {
        ScrolledComposite scrolled = new ScrolledComposite((Composite)folder, 2560);
        Composite content = this.display(scrolled, environment);
        scrolled.addControlListener(ControlListener.controlResizedAdapter(e -> {
            Rectangle area = scrolled.getClientArea();
            scrolled.setMinSize(content.computeSize(area.width, -1));
        }));
        return scrolled;
    }

    private Composite display(ScrolledComposite scrolled, RuntimeEnvironment environment) {
        Composite composite = new Composite((Composite)scrolled, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        Text state = new Text(composite, 74);
        state.setLayoutData((Object)new GridData(4, 4, true, true));
        state.setText(this.state(environment));
        composite.pack();
        scrolled.setContent((Control)composite);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(500, 700);
        shell.setText(EnvironmentStateDialogMessages.EnvironmentStatesDialog_title);
    }

    private String state(RuntimeEnvironment environment) {
        try {
            return environment.state();
        }
        catch (LicensingException e) {
            return String.format(EnvironmentStateDialogMessages.EnvironmentStatesDialog_env_error, environment.id(), e.getLocalizedMessage());
        }
    }
}

