/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriodOpen;
import org.eclipse.passage.lic.licenses.model.api.LicenseGrant;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;

final class PersonalLicenseGenerated
implements Supplier<LicensePack> {
    private final LicensedProduct product;
    private final String user;
    private final Collection<Condition> conditions;

    PersonalLicenseGenerated(LicensedProduct product, String user, Collection<Condition> conditions) {
        this.product = product;
        this.user = user;
        this.conditions = conditions;
    }

    @Override
    public LicensePack get() {
        LicensePack pack = LicensesFactory.eINSTANCE.createLicensePack();
        pack.setIdentifier(this.generated());
        pack.setIssueDate(new Date());
        pack.setPlanIdentifier("ignored");
        pack.setProductIdentifier(this.product.identifier());
        pack.setProductVersion(this.product.version());
        pack.setUserFullName(this.user);
        pack.setUserIdentifier(this.user);
        pack.setRequestIdentifier(this.generated());
        this.conditions.stream().map(this::grant).forEach(arg_0 -> pack.getLicenseGrants().add(arg_0));
        return pack;
    }

    private String generated() {
        return String.format("generated:%s", UUID.randomUUID().toString());
    }

    private LicenseGrant grant(Condition condition) {
        LicensesFactory licenseFactory = LicensesFactory.eINSTANCE;
        LicenseGrant grant = licenseFactory.createLicenseGrant();
        grant.setIdentifier(condition.identifier());
        grant.setFeatureIdentifier(condition.feature());
        grant.setMatchVersion(condition.versionMatch().version());
        grant.setMatchRule(condition.versionMatch().rule().identifier());
        grant.setCapacity(1);
        grant.setConditionExpression(condition.evaluationInstructions().expression());
        grant.setConditionType(condition.evaluationInstructions().type().identifier());
        grant.setValidFrom(this.date(condition, ValidityPeriodOpen::from));
        grant.setValidUntil(this.date(condition, ValidityPeriodClosed::to));
        return grant;
    }

    private Date date(Condition condition, Function<ValidityPeriodClosed, ZonedDateTime> source) {
        ValidityPeriodClosed closed = (ValidityPeriodClosed)condition.validityPeriod();
        return Date.from(source.apply(closed).toInstant());
    }
}

