/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.jface.dialogs;

import java.time.LocalDate;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Shell;

public class DateDialog
extends Dialog {
    private DateTime calendar;
    private LocalDate selected;

    public DateDialog(Shell shell, LocalDate initial) {
        super(shell);
        this.selected = initial != null ? initial : LocalDate.now();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.calendar = new DateTime(area, 3072);
        this.showLocalDate(this.selected);
        return area;
    }

    protected LocalDate collectLocalDateTime() {
        int year = this.calendar.getYear();
        int month = this.calendar.getMonth();
        int day = this.calendar.getDay();
        return LocalDate.of(year, month + 1, day);
    }

    protected void showLocalDate(LocalDate localDate) {
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        int day = localDate.getDayOfMonth();
        this.calendar.setDate(year, month - 1, day);
    }

    protected void okPressed() {
        this.selected = this.collectLocalDateTime();
        super.okPressed();
    }

    public LocalDate getSelected() {
        return this.selected;
    }
}

