/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.features.emfforms.renderers;

import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.passage.lic.features.FeatureDescriptor;
import org.eclipse.passage.loc.features.ui.FeaturesUi;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.workbench.emfforms.renderers.TextWithButtonRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FeatureIdentifierRenderer
extends TextWithButtonRenderer {
    private static final String IDENTIFIER_EMPTY = "";
    private final FeatureRegistry registry;

    @Inject
    public FeatureIdentifierRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.registry = (FeatureRegistry)viewContext.getService(FeatureRegistry.class);
    }

    protected Control createSWTControl(Composite parent) {
        Control control = super.createSWTControl(parent);
        this.text.setEditable(true);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureIdentifierRenderer.this.selectIdentifier();
            }
        });
        return control;
    }

    protected String getUnsetText() {
        return IDENTIFIER_EMPTY;
    }

    protected void selectIdentifier() {
        String identifier;
        FeatureDescriptor descriptor;
        Shell shell = Display.getDefault().getActiveShell();
        FeatureDescriptor initial = null;
        try {
            Object value = this.getModelValue().getValue();
            if (value instanceof String) {
                String id = (String)value;
                initial = this.registry.getFeature(id);
            }
        }
        catch (DatabindingFailedException e) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)e));
        }
        if ((descriptor = FeaturesUi.selectFeatureDescriptor((Shell)shell, (FeatureRegistry)this.registry, initial)) != null && (identifier = descriptor.getIdentifier()) != null) {
            this.text.setText(identifier);
        }
    }
}

