/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.mining;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnInfrastructureDenial;
import org.eclipse.passage.lic.internal.base.i18n.ConditionMiningMessages;
import org.eclipse.passage.lic.internal.base.io.FileCollection;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;

public abstract class LocalConditions
implements MinedConditions {
    private final StringServiceId id;
    private final MiningEquipment equipment;

    protected LocalConditions(StringServiceId id, MiningEquipment equipment) {
        Objects.requireNonNull(id, String.valueOf(this.getClass().getSimpleName()) + "::id");
        Objects.requireNonNull(equipment, String.valueOf(this.getClass().getSimpleName()) + "::equipment");
        this.id = id;
        this.equipment = equipment;
    }

    public final StringServiceId id() {
        return this.id;
    }

    public final ServiceInvocationResult<Collection<ConditionPack>> all(LicensedProduct product) {
        try {
            return this.equipment.tool(product).mine(this.licenses(product));
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult<Collection<ConditionPack>>(new Trouble((TroubleCode)new ServiceFailedOnInfrastructureDenial(), ConditionMiningMessages.getString("LocalConditions.failed"), (Exception)((Object)e)));
        }
    }

    private Collection<Path> licenses(LicensedProduct product) throws LicensingException {
        return new FileCollection(this.base(product), new PassageFileExtension.LicenseEncrypted()).get();
    }

    protected abstract Supplier<Path> base(LicensedProduct var1);
}

