/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.internal.base.inspection.hardware.BaseBoard;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Computer;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Cpu;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Disk;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Firmware;
import org.eclipse.passage.lic.internal.base.inspection.hardware.OS;
import org.eclipse.passage.lic.internal.oshi.i18n.AssessmentMessages;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Firmware;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

final class State {
    private final Map<EnvironmentProperty, String> hardware = new HashMap<EnvironmentProperty, String>();
    private final String diskFamily = new Disk.Name().family();
    private final List<Map<EnvironmentProperty, String>> disks = new ArrayList<Map<EnvironmentProperty, String>>();

    State() throws LicensingException {
        this.read();
    }

    boolean hasValue(EnvironmentProperty property, String expected) {
        String regexp = expected.replaceAll("\\*", ".*");
        if (this.diskFamily.equals(property.family())) {
            return this.disks.stream().map(properties -> Optional.ofNullable((String)properties.get(property))).filter(Optional::isPresent).map(Optional::get).anyMatch(value -> value.matches(regexp));
        }
        return Optional.ofNullable(this.hardware.get(property)).map(value -> value.matches(regexp)).orElse(false);
    }

    Set<EnvironmentProperty> properties() {
        return this.hardware.keySet();
    }

    String value(EnvironmentProperty key) {
        return this.hardware.get(key);
    }

    int disksAmount() {
        return this.disks.size();
    }

    Set<EnvironmentProperty> diskProperties(int no) {
        return this.disks.get(no).keySet();
    }

    String diskValue(int no, EnvironmentProperty key) {
        return this.disks.get(no).get(key);
    }

    private void read() throws LicensingException {
        try {
            SystemInfo system = new SystemInfo();
            this.readOS(system.getOperatingSystem());
            this.readHal(system.getHardware());
        }
        catch (Throwable e) {
            throw new LicensingException(AssessmentMessages.State_error_reading_hw, e);
        }
    }

    private void readOS(OperatingSystem info) {
        this.store(() -> ((OperatingSystem)info).getFamily(), (EnvironmentProperty)new OS.Family(), this.hardware);
        this.store(() -> ((OperatingSystem)info).getManufacturer(), (EnvironmentProperty)new OS.Manufacturer(), this.hardware);
        this.store(() -> ((OperatingSystemVersion)info.getVersion()).getVersion(), (EnvironmentProperty)new OS.Version(), this.hardware);
        this.store(() -> ((OperatingSystemVersion)info.getVersion()).getBuildNumber(), (EnvironmentProperty)new OS.BuildNumber(), this.hardware);
    }

    private void readHal(HardwareAbstractionLayer hal) {
        this.readSystem(hal.getComputerSystem());
        this.readProcessor(hal.getProcessor());
        this.readDisks(hal.getDiskStores());
    }

    private void readSystem(ComputerSystem info) {
        this.store(() -> ((ComputerSystem)info).getManufacturer(), (EnvironmentProperty)new Computer.Manufacturer(), this.hardware);
        this.store(() -> ((ComputerSystem)info).getModel(), (EnvironmentProperty)new Computer.Model(), this.hardware);
        this.store(() -> ((ComputerSystem)info).getSerialNumber(), (EnvironmentProperty)new Computer.Serial(), this.hardware);
        this.readBaseBoard(info.getBaseboard());
        this.readFirmware(info.getFirmware());
    }

    private void readBaseBoard(Baseboard info) {
        this.store(() -> ((Baseboard)info).getManufacturer(), (EnvironmentProperty)new BaseBoard.Manufacturer(), this.hardware);
        this.store(() -> ((Baseboard)info).getModel(), (EnvironmentProperty)new BaseBoard.Model(), this.hardware);
        this.store(() -> ((Baseboard)info).getVersion(), (EnvironmentProperty)new BaseBoard.Version(), this.hardware);
        this.store(() -> ((Baseboard)info).getSerialNumber(), (EnvironmentProperty)new BaseBoard.Serial(), this.hardware);
    }

    private void readFirmware(Firmware info) {
        this.store(() -> ((Firmware)info).getManufacturer(), (EnvironmentProperty)new Firmware.Manufacturer(), this.hardware);
        this.store(() -> ((Firmware)info).getVersion(), (EnvironmentProperty)new Firmware.Version(), this.hardware);
        this.store(() -> ((Firmware)info).getReleaseDate(), (EnvironmentProperty)new Firmware.ReleaseDate(), this.hardware);
        this.store(() -> ((Firmware)info).getName(), (EnvironmentProperty)new Firmware.Name(), this.hardware);
        this.store(() -> ((Firmware)info).getDescription(), (EnvironmentProperty)new Firmware.Description(), this.hardware);
    }

    private void readProcessor(CentralProcessor info) {
        this.store(() -> ((CentralProcessor)info).getVendor(), (EnvironmentProperty)new Cpu.Vendor(), this.hardware);
        this.store(() -> ((CentralProcessor)info).getFamily(), (EnvironmentProperty)new Cpu.Family(), this.hardware);
        this.store(() -> ((CentralProcessor)info).getModel(), (EnvironmentProperty)new Cpu.Model(), this.hardware);
        this.store(() -> ((CentralProcessor)info).getName(), (EnvironmentProperty)new Cpu.Name(), this.hardware);
        this.store(() -> ((CentralProcessor)info).getProcessorID(), (EnvironmentProperty)new Cpu.ProcessorId(), this.hardware);
    }

    private void readDisks(HWDiskStore[] info) {
        Arrays.stream(info).map(this::diskProperties).forEach(this.disks::add);
    }

    private Map<EnvironmentProperty, String> diskProperties(HWDiskStore info) {
        HashMap<EnvironmentProperty, String> props = new HashMap<EnvironmentProperty, String>();
        this.store(() -> ((HWDiskStore)info).getName(), (EnvironmentProperty)new Disk.Name(), props);
        this.store(() -> ((HWDiskStore)info).getModel(), (EnvironmentProperty)new Disk.Model(), props);
        this.store(() -> ((HWDiskStore)info).getSerial(), (EnvironmentProperty)new Disk.Serial(), props);
        return props;
    }

    private void store(Supplier<String> value, EnvironmentProperty key, Map<EnvironmentProperty, String> target) {
        Optional.ofNullable(value.get()).ifPresent(valuable -> {
            String string = target.put(key, (String)valuable);
        });
    }
}

