/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.viewers;

import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.api.inspector.FeatureInspector;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.base.LicensingProperties;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.jface.viewers.ConditionRepresenters;
import org.eclipse.passage.lic.jface.viewers.LicensingViewerBasis;
import org.eclipse.passage.lic.jface.viewers.RequirementLabels;
import org.eclipse.swt.graphics.RGB;

public class LicensingConditionViewerAdapter
extends LicensingViewerBasis {
    protected static final int INDEX_STATUS = 0;
    protected static final int INDEX_PROVIDER = 1;
    protected static final int INDEX_NAME = 2;
    protected static final int INDEX_IDENTIFIER = 3;
    protected static final int INDEX_VALID_FROM = 4;
    protected static final int INDEX_VALID_UNTIL = 5;
    protected static final int INDEX_MATCH_VERSION = 6;
    protected static final int INDEX_MATCH_RULE = 7;
    protected static final int INDEX_CONDITION_TYPE = 8;

    public LicensingConditionViewerAdapter(FeatureInspector inspectorOffice) {
        super(inspectorOffice);
    }

    @Override
    public String getLabel(Object element) {
        if (element instanceof LicensingCondition) {
            LicensingCondition condition = (LicensingCondition)element;
            return condition.getFeatureIdentifier();
        }
        return super.getLabel(element);
    }

    @Override
    public String getLabel(Object element, int columnIndex) {
        if (element instanceof LicensingCondition) {
            LicensingCondition condition = (LicensingCondition)element;
            String featureIdentifier = condition.getFeatureIdentifier();
            Iterable<LicensingRequirement> requirements = this.getRequirements(featureIdentifier);
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return RequirementLabels.getFeatureProvider(requirements);
                }
                case 2: {
                    return RequirementLabels.getFeatureName(requirements);
                }
                case 3: {
                    return condition.getFeatureIdentifier();
                }
                case 4: {
                    return LicensingProperties.getLicensingDateFormat((Date)condition.getValidFrom());
                }
                case 5: {
                    return LicensingProperties.getLicensingDateFormat((Date)condition.getValidUntil());
                }
                case 6: {
                    return condition.getMatchVersion();
                }
                case 7: {
                    return condition.getMatchRule();
                }
                case 8: {
                    return condition.getConditionType();
                }
            }
        }
        return super.getLabel(element, columnIndex);
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object element, int columnIndex) {
        if (element instanceof LicensingCondition) {
            LicensingCondition condition = (LicensingCondition)element;
            String imageKey = ConditionRepresenters.resolveImageKey(condition);
            switch (columnIndex) {
                case 0: {
                    return LicensingImages.getImageDescriptor(imageKey);
                }
            }
        }
        return super.getImageDescriptor(element, columnIndex);
    }

    @Override
    public RGB getBackground(Object element) {
        if (element instanceof LicensingCondition) {
            LicensingCondition condition = (LicensingCondition)element;
            return ConditionRepresenters.resolveRGB(condition);
        }
        return super.getBackground(element);
    }
}

