/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.app;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;

public final class ApplicationBranding {
    private static final String[] NO_MAPPINGS = new String[0];
    public static final String ABOUT_TEXT = "aboutText";
    private static final String ABOUT_MAPPINGS = "$nl$/about.mappings";
    private static Map<Bundle, String[]> mappingsMap = new HashMap<Bundle, String[]>(4);

    public static String getAboutText(IApplicationContext context) {
        String property = context.getBrandingProperty(ABOUT_TEXT);
        Bundle brandingBundle = context.getBrandingBundle();
        return ApplicationBranding.extractValue(property, brandingBundle);
    }

    private static String extractValue(String property, Bundle definingBundle) {
        if (property == null) {
            return "";
        }
        if (property.indexOf(123) == -1) {
            return property;
        }
        Object[] tempMappings = ApplicationBranding.getMappings(definingBundle);
        int i = 0;
        while (i < tempMappings.length) {
            Object nextString = tempMappings[i];
            int length = ((String)nextString).length();
            if (length > 2 && ((String)nextString).charAt(0) == '$' && ((String)nextString).charAt(length - 1) == '$') {
                String systemPropertyKey = ((String)nextString).substring(1, length - 1);
                tempMappings[i] = System.getProperty(systemPropertyKey, "");
            }
            ++i;
        }
        return MessageFormat.format(property, tempMappings);
    }

    private static String[] loadMappings(Bundle definingBundle) {
        URL location = FileLocator.find((Bundle)definingBundle, (IPath)new Path(ABOUT_MAPPINGS));
        if (location == null) {
            return NO_MAPPINGS;
        }
        PropertyResourceBundle resources = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = location.openStream();){
                resources = new PropertyResourceBundle(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return NO_MAPPINGS;
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        boolean found = true;
        int i = 0;
        while (found) {
            try {
                mappingsList.add(resources.getString(Integer.toString(i)));
            }
            catch (MissingResourceException e) {
                found = false;
            }
            ++i;
        }
        String[] mappings = mappingsList.toArray(new String[mappingsList.size()]);
        mappingsMap.put(definingBundle, mappings);
        return mappings;
    }

    private static String[] getMappings(Bundle definingBundle) {
        String[] mappings = mappingsMap.get(definingBundle);
        if (mappings == null) {
            mappings = ApplicationBranding.loadMappings(definingBundle);
        }
        if (mappings == null) {
            mappings = NO_MAPPINGS;
        }
        return mappings;
    }
}

