/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.resource;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LicensingImages {
    public static final String IMG_DEFAULT = "IMG_DEFAULT";
    public static final String IMG_LEVEL_OK = "IMG_LEVEL_OK";
    public static final String IMG_LEVEL_INFO = "IMG_LEVEL_INFO";
    public static final String IMG_LEVEL_WARN = "IMG_LEVEL_WARN";
    public static final String IMG_LEVEL_ERROR = "IMG_LEVEL_ERROR";
    public static final String IMG_LEVEL_FATAL = "IMG_LEVEL_FATAL";
    public static final String IMG_EXPORT = "IMG_EXPORT";
    public static final String IMG_IMPORT = "IMG_IMPORT";
    public static final String IMG_INSPECTOR = "IMG_INSPECTOR";
    public static final String PATH_ICONS = "$nl$/icons/";
    public static final String PATH_ETOOL = "$nl$/icons/etool16/";
    public static final String PATH_DTOOL = "$nl$/icons/dtool16/";
    public static final String PATH_EVIEW = "$nl$/icons/eview16/";
    public static final String PATH_OVERLAY = "$nl$/icons/ovr16/";
    public static final String PATH_OBJECT = "$nl$/icons/obj16/";
    public static final String PATH_WIZBAN = "$nl$/icons/wizban/";
    private static ImageRegistry imageRegistry = null;

    public static Image getImage(String key) {
        return LicensingImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return LicensingImages.getImageRegistry().getDescriptor(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(JFaceResources.getResources((Display)Display.getCurrent()));
            LicensingImages.initializeDefaultImages();
        }
        return imageRegistry;
    }

    private static void initializeDefaultImages() {
        HashMap<String, String> paths = new HashMap<String, String>();
        paths.put(IMG_DEFAULT, "$nl$/icons/obj16/passage.png");
        paths.put(IMG_LEVEL_OK, "$nl$/icons/obj16/ok.png");
        paths.put(IMG_LEVEL_INFO, "$nl$/icons/obj16/info.png");
        paths.put(IMG_LEVEL_WARN, "$nl$/icons/obj16/warn.png");
        paths.put(IMG_LEVEL_ERROR, "$nl$/icons/obj16/error.png");
        paths.put(IMG_LEVEL_FATAL, "$nl$/icons/obj16/fatal.png");
        paths.put(IMG_EXPORT, "$nl$/icons/etool16/export.png");
        paths.put(IMG_IMPORT, "$nl$/icons/etool16/import.png");
        paths.put(IMG_INSPECTOR, "$nl$/icons/etool16/hw-inspector.png");
        LicensingImages.declareImages(LicensingImages.class, paths);
    }

    public static IStatus declareImages(Class<?> location, Map<String, String> paths) {
        ImageRegistry registry = LicensingImages.getImageRegistry();
        Bundle bundle = null;
        try {
            bundle = FrameworkUtil.getBundle(location);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Set<Map.Entry<String, String>> entries = paths.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            URL url;
            String key = entry.getKey();
            String path = entry.getValue();
            ImageDescriptor descriptor = null;
            if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
                descriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.createFromFile(location, (String)path);
            }
            if (descriptor == null) continue;
            registry.put(key, descriptor);
        }
        return Status.OK_STATUS;
    }
}

